package ch.sahits.game.graphic.display.dialog.guild;

import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.city.guild.GuildSettings;
import ch.sahits.game.openpatrician.model.city.guild.IMediterreanMap;
import ch.sahits.game.openpatrician.model.city.guild.ITradeAgreement;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import javafx.scene.layout.VBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;

/**
 * Dialog to display the trade agreements.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 04, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class GuildTradeAgreementDialog extends CloseButtonDialog {
    /** Reference to the city view model */
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private GuildSettings guildSettings;
    @Autowired
    private ModelTranslations modelTranslations;

    public GuildTradeAgreementDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildTradeAgreementDialog.title",
                new Object[]{}, locale.getCurrentLocal()));
        IMediterreanMap map = guildSettings.getMediterreanMap();
        List<ITradeAgreement> agreements = map.getTradeAgreements(city.getPlayer());
        VBox box = new VBox(10);

        for (ITradeAgreement agreement : agreements) {
            String cityName = agreement.getTradeLocation().getName();
            String ware = modelTranslations.getLocalDisplayName((EWare) agreement.getWare());
            int price = agreement.getWareAndAmount().getAVGPrice();
            int amount = agreement.getWareAndAmount().getAmount();
            String till = modelTranslations.toDisplayString(agreement.getValidTill());
            String template = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildTradeAgreementDialog.agreement",
                    new Object[]{cityName, amount, ware, price, till}, locale.getCurrentLocal());
            DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
            box.getChildren().add(text);
        }
        box.setLayoutX(2 * FRAME_BORDER);
        box.setLayoutY(CLOSE_BTN_Y_POS - 500);
        getContent().add(box);
    }
}
