package ch.sahits.game.graphic.display.dialog.loaner;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * List all the loans a player has granted.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 06, 2015
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerListLoansDialog extends DefaultSimpleDialog {

    @Autowired
    private ModelTranslations translator;
    @Autowired
    private ClientViewState viewState;

    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @Autowired
    private LoanerService loanerService;
    public LoanerListLoansDialog(ICityPlayerProxyJFX city) {
        super(false);
        this.city = city;
    }
    @PostConstruct
    private void initializeDialog() {
        final ICity city1 = city.getCity();
        loaner = (LoanerState) loanerService.findLoaner(city1);
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.title", new Object[]{}, locale.getCurrentLocal()));
        addDecoratedText("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.subHeader", "introText");
        addVerticalSpacer(20);
        String cityName = city1.getName();
        for (IDebt debt : loanerService.findLoans(loaner, city.getPlayer())) {
            final ICitizen debitor = debt.getDebitor();
            String title = translator.getLocalDisplayName(debitor.getRank());
            int paybacksum = (int)(debt.getInterest() * debt.getAmount());
            final DateTime dueDate1 = debt.getDueDate();
            String dueDate = translator.toDisplayString(dueDate1);
            addDecoratedText("ch.sahits.game.graphic.display.dialog.LoanerListLoansDialog.outstandingLoan", "outstandingLoan", title, debitor.getName(), debitor.getLastName(), cityName, paybacksum, dueDate);
        }
    }
    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_LOANER);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
}
