package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernEscortDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;


    public TavernEscortDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getEscorte());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IEscorte escort = (IEscorte) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("destination", escort.getDestination().getName());
        parameters.put("price", escort.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            if ((IShip)city.getActiveShip()!=null) {
                IEscorte escort = (IEscorte) currentPerson.get();
                IShip ship = (IShip) city.getActiveShip();
                ship.addPassenger(escort);
                eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, escort.getDestination(), city.getPlayer(), escort.getPremium());
                clientEventBus.post(new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernEscortDialog.acceptMessage", new Object[]{ship.getName()}));
                escort.leave();
                city.getPlayer().updateCrimialDrive(-1);
                executeOnCloseButtonClicked();
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                if (city.getActiveShip() instanceof IShip) {
                    ((IShip)city.getActiveShip()).passengerPresentProperty();
                }
            }
            @Override
            protected boolean computeValue() {
                return !(city.getActiveShip() instanceof IShip) || city.getPlayersShips().isEmpty() || ((IShip)city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }
}
