package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.MapSegmentImageFactory;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPirateHunterDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapSegmentImageFactory segmentFactory;
    @Autowired
    private MapLocationDetectionModel locationDetector;



    public TavernPirateHunterDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getPirateHunter());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IPirateHunter pirateHunter = (IPirateHunter) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.dialog1", new Object[]{pirateHunter.getClientName(), pirateHunter.getPremium()}, locale.getCurrentLocal());


        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, new HashMap<>());


        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            removeDecoratedContent();
            removeAcceptButton();
            MapSegmentedImage imageMap = segmentFactory.getRandomPirateNest();
            String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernPirateHunterDialog.acceptMessage", new Object[]{imageMap.getImageName()}, locale.getCurrentLocal());
            HashMap<String, Object> parameters = new HashMap<>();
            List<Integer> visibleSegs = new ArrayList<>();
            visibleSegs.addAll(imageMap.getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            final DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);
            Platform.runLater(() -> getContent().add(dt));

            IPirateHunter pirateHunter = (IPirateHunter) currentPerson.get();
            final IPlayer player = city.getPlayer();
            player.getCompany().updateCash(-pirateHunter.getPremium());
            player.setSegmentedMap(imageMap);
            locationDetector.addSegment(imageMap);

            city.getPlayer().updateCrimialDrive(-1);
            pirateHunter.leave();
            executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            @Override
            protected boolean computeValue() {
                return false;
            }
        };
    }
}
