package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.map.MapSegmentedImage;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.server.MapLocationDetectionModel;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.MapSegmentImageFactory;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 26, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTreasureMapOwnerDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private Random rnd;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private MapSegmentImageFactory segmentFactory;
    @Autowired
    private MapLocationDetectionModel locationDetector;

    public TavernTreasureMapOwnerDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getTreasureMap());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTreasureMapOwnerDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        ITreasureMapOwner mapOwner = (ITreasureMapOwner) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTreasureMapOwnerDialog.dialog",
                new Object[]{city.getPlayer().getLastName()}, locale.getCurrentLocal());


        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("price", mapOwner.getPrice());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            removeDecoratedContent();
            removeAcceptButton();
            MapSegmentedImage imageMap = segmentFactory.getRandomTreasureNest();
            String loadedText = messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTreasureMapOwnerDialog.acceptMessage", new Object[]{imageMap.getImageName()}, locale.getCurrentLocal());
            HashMap<String, Object> parameters = new HashMap<>();
            List<Integer> visibleSegs = new ArrayList<>();
            visibleSegs.addAll(imageMap.getSegmentIndices());
            parameters.put("visibleSegments", visibleSegs);
            final DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);
            Platform.runLater(() -> getContent().add(dt));


            IPlayer player = city.getPlayer();
            player.setSegmentedMap(imageMap);
            locationDetector.addSegment(imageMap);

            ITreasureMapOwner mapOwner = (ITreasureMapOwner) currentPerson.get();
            player.getCompany().updateCash(-mapOwner.getPrice());
            mapOwner.leave();
            executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            @Override
            protected boolean computeValue() {
                return false;
            }
        };
    }
}
