package ch.sahits.game.graphic.display.dialog.util;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog;
import ch.sahits.game.graphic.display.dialog.CityProductionConsumptionDialog;
import ch.sahits.game.graphic.display.dialog.CityShipTradeDialog;
import ch.sahits.game.graphic.display.dialog.CityStorageTradeDialog;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.GenericCloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.HistoryStandaloneDialog;
import ch.sahits.game.graphic.display.dialog.PersonalDialog;
import ch.sahits.game.graphic.display.dialog.StorageOverviewDialog;
import ch.sahits.game.graphic.display.dialog.StorageShipTradeDialog;
import ch.sahits.game.graphic.display.dialog.TradeOfficeBalanceDialog;
import ch.sahits.game.graphic.display.dialog.WareInStockDialog;
import ch.sahits.game.graphic.display.dialog.WeaponInventoryDialog;
import ch.sahits.game.graphic.display.dialog.church.ChurchExtensionDialog;
import ch.sahits.game.graphic.display.dialog.church.ChurchFeedingDialog;
import ch.sahits.game.graphic.display.dialog.church.ChurchGiftDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.AldermanOfficeDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.CityWallBuildingDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.HanseaticInfoDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.MeetingRoomDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.OutriggerNoticeDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.PublicNoticeDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.TownInfoDialog;
import ch.sahits.game.graphic.display.dialog.cityhall.TreasuryDialog;
import ch.sahits.game.graphic.display.dialog.guild.AuctionGuildDialog;
import ch.sahits.game.graphic.display.dialog.guild.GuildMediterraneanMapDialog;
import ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog;
import ch.sahits.game.graphic.display.dialog.guild.GuildTradeAgreementDialog;
import ch.sahits.game.graphic.display.dialog.guild.JoinGuildDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerGiveLoanDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerListLoansDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerPaybackDialog;
import ch.sahits.game.graphic.display.dialog.loaner.LoanerTakeLoanDialog;
import ch.sahits.game.graphic.display.dialog.sea.ConvoyDialog;
import ch.sahits.game.graphic.display.dialog.sea.LeaveConvoyDialog;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipRepairDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardConstructionDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardConstructionListDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardRenameDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardRepairListDialogV2;
import ch.sahits.game.graphic.display.dialog.shipyard.ShipyardUpgradeDialogV2;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBurglarDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernBuyerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernCaptainDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernConcurrentDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernCourierDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernEscortDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernFugativeDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernInformantDialogPageOne;
import ch.sahits.game.graphic.display.dialog.tavern.TavernInformantDialogPageTwo;
import ch.sahits.game.graphic.display.dialog.tavern.TavernPatrolDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernPirateDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernPirateHunterDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernSailorDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernSmugglerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTraderDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTransportTraderDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTravelerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernTreasureMapOwnerDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernWarehouseTenantDialog;
import ch.sahits.game.graphic.display.dialog.tavern.TavernWeaponsDealerDialog;
import ch.sahits.game.graphic.image.IFontLoader;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.dialog.Dialog;
import ch.sahits.game.openpatrician.dialog.DialogTemplate;
import ch.sahits.game.openpatrician.dialog.IDialogState;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.IConcurrent;
import ch.sahits.game.openpatrician.model.people.ICourier;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.people.IFugitive;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.people.IPirateHunter;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.people.IThieve;
import ch.sahits.game.openpatrician.model.people.ITransportTrader;
import ch.sahits.game.openpatrician.model.people.ITreasureMapOwner;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class DialogFactory {
	@Autowired
	private ApplicationContext context;
	@Autowired
	private IFontLoader fontLoader;
    @Autowired
    private ClientViewState clientViewState;

    public Dialog getDialog(DialogTemplate template) {
        return (GenericCloseButtonDialog) context.getBean("genericCloseButtonDialog", template);
    }

    private HistoryStandaloneDialog getHistoryDialog(ICityPlayerProxyJFX cityProxy, String resourceName) {
        return (HistoryStandaloneDialog) context.getBean("historyStandaloneDialog", cityProxy, resourceName);
    }
    private String getHistoryResourceName(String name) {
        return "history."+name;
    }
	public Dialog getDialog(EDialogType dialogType, ICityPlayerProxyJFX cityProxy) {
		switch (dialogType) {
		case PORT_CITY_TO_SHIP:
			return (CityShipTradeDialog) context.getBean("cityShipTradeDialog", cityProxy);
		case PORT_CITY_TO_STORAGE:
			return (CityStorageTradeDialog) context.getBean("cityStorageTradeDialog", cityProxy);
		case PORT_STORAGE_TO_SHIP:
			return (StorageShipTradeDialog) context.getBean("storageShipTradeDialog", cityProxy);
		case TO_BALANCE:
			return (TradeOfficeBalanceDialog) context.getBean("tradeOfficeBalanceDialog", cityProxy);
		case TO_PERSONAL:
			return (PersonalDialog) context.getBean("personalDialog", cityProxy);
		case TO_CONSUMPTION_PRODUCTION:
        case MB_CONSUMPTION_PRODUCTION:
			return (CityProductionConsumptionDialog) context.getBean("cityProductionConsumptionDialog", cityProxy);
		case TO_WEAPONS:
			return (WeaponInventoryDialog) context.getBean("weaponInventoryDialog", cityProxy);
		case TO_WAREHOUSES:
			return (StorageOverviewDialog) context.getBean("storageOverviewDialog", cityProxy);
		case TO_OFFICE_TRADING:
			return (AutomaticTradingOverviewDialog) context.getBean("automaticTradingOverviewDialog", cityProxy);
        case MB_STOCK_PRICES:
            return (WareInStockDialog) context.getBean("wareInStockDialog", cityProxy);
        case SHIPYARD_CONSTRUCTION:
            return (ShipyardConstructionDialogV2) context.getBean("shipyardConstructionDialog", cityProxy);
        case SHIPYARD_REPAIR:
            return (ShipRepairDialogV2) context.getBean("shipRepairDialog", cityProxy);
        case SHIPYARD_CONSTRUCTION_LIST:
            return (ShipyardConstructionListDialogV2) context.getBean("shipyardConstructionListDialog", cityProxy);
        case SHIPYARD_REPAIR_LIST:
            return (ShipyardRepairListDialogV2) context.getBean("shipyardRepairListDialog", cityProxy);
        case SHIPYARD_UPGRADE:
            return (ShipyardUpgradeDialogV2) context.getBean("shipyardUpgradeDialog", cityProxy);
        case SHIPYARD_RENAME:
            return (ShipyardRenameDialogV2) context.getBean("shipyardRenameDialog", cityProxy);
        case TAVERN_SAILORS:
            return (TavernSailorDialog) context.getBean("tavernSailorDialog", cityProxy);
        case TAVERN_CAPTAIN:
            return (TavernCaptainDialog) context.getBean("tavernCaptainDialog", cityProxy);
        case TAVERN_WEAPONS_DEALER:
            return (TavernWeaponsDealerDialog) context.getBean("tavernWeaponsDealerDialog", cityProxy);
        case TAVERN_PIRATE:
            return (TavernPirateDialog) context.getBean("tavernPirateDialog", cityProxy);
        case TAVERN_TRADER:
            return (TavernTraderDialog) context.getBean("tavernTraderDialog", cityProxy);
        case TAVERN_TRAVELER:
            return (TavernTravelerDialog) context.getBean("tavernTravelerDialog", cityProxy);
        case TAVERN_TREASUREMAP_OWNER:
            return (TavernTreasureMapOwnerDialog) context.getBean("tavernTreasureMapOwnerDialog", cityProxy);
        case TAVERN_INFORMANT_1:
            return (TavernInformantDialogPageOne) context.getBean("tavernInformantDialogPageOne", cityProxy);
        case TAVERN_INFORMANT_2:
            return (TavernInformantDialogPageTwo) context.getBean("tavernInformantDialogPageTwo", cityProxy);
        case TAVERN_SIDE_ROOM:
        {
            final TavernState tavernState = cityProxy.getCity().getCityState().getTavernState();
            synchronized (tavernState) {
                ISideRoomPerson sideRoomPerson = tavernState.presentPersonsInSideRoomBinding().get().get(0);
                return createDialogForSideRoom(sideRoomPerson, cityProxy);
            }
        }
        case TAVERN_COURIER:
            return (TavernCourierDialog) context.getBean("tavernCourierDialog", cityProxy);
        case TAVERN_BURGLAR:
            return (TavernBurglarDialog) context.getBean("tavernBurglarDialog", cityProxy);
        case TAVERN_TRANSPORT_TRADER:
            return (TavernTransportTraderDialog) context.getBean("tavernTransportTraderDialog", cityProxy);
        case TAVERN_WAREHOUSE_TENANT:
            return (TavernWarehouseTenantDialog) context.getBean("tavernWarehouseTenantDialog", cityProxy);
        case TAVERN_SMUGGLER:
            return (TavernSmugglerDialog) context.getBean("tavernSmugglerDialog", cityProxy);
        case TAVERN_PIRATE_HUNTER:
            return (TavernPirateHunterDialog) context.getBean("tavernPirateHunterDialog", cityProxy);
        case TAVERN_PATROL:
            return (TavernPatrolDialog) context.getBean("tavernPatrolDialog", cityProxy);
        case TAVERN_BUYER:
            return (TavernBuyerDialog) context.getBean("tavernBuyerDialog", cityProxy);
        case TAVERN_CONCURRENT:
            return (TavernConcurrentDialog) context.getBean("tavernConcurrentDialog", cityProxy);
        case TAVERN_ESCORTE:
            return (TavernEscortDialog) context.getBean("tavernEscortDialog", cityProxy);
        case TAVERN_FUGATIVE:
            return (TavernFugativeDialog) context.getBean("tavernFugativeDialog", cityProxy);
        case LOANER_TAKE:
            return (LoanerTakeLoanDialog) context.getBean("loanerTakeLoanDialog", cityProxy);
        case LOANER_GIVE:
            return (LoanerGiveLoanDialog) context.getBean("loanerGiveLoanDialog", cityProxy);
        case LOANER_REPAY:
            return (LoanerPaybackDialog) context.getBean("loanerPaybackDialog", cityProxy);
        case LOANER_LIST:
            return (LoanerListLoansDialog) context.getBean("loanerListLoansDialog", cityProxy);
        case CITY_HALL_NOTICE:
            return (PublicNoticeDialog) context.getBean("publicNoticeDialog", cityProxy);
        case CITY_HALL_OUTRIGGER:
            return (OutriggerNoticeDialog) context.getBean("outriggerNoticeDialog", cityProxy);
        case CITY_HALL_TOWN_INFO:
            return (TownInfoDialog) context.getBean("townInfoDialog", cityProxy);
        case CITY_HALL_TREASURY:
            return (TreasuryDialog) context.getBean("treasuryDialog", cityProxy);
        case CITY_HALL_HANSEATIC_INFO:
            return (HanseaticInfoDialog)  context.getBean("hanseaticInfoDialog", cityProxy);
        case CITY_HALL_ALDERMAN_OFFICE:
            return (AldermanOfficeDialog)  context.getBean("aldermanOfficeDialog", cityProxy);
        case CITY_HALL_MEETING_ROOM:
            return (MeetingRoomDialog)  context.getBean("meetingRoomDialog", cityProxy);
        case CITY_HALL_CITY_WALL:
            return (CityWallBuildingDialog)  context.getBean("cityWallBuildingDialog", cityProxy);
        case CHURCH_FEED:
            return (ChurchFeedingDialog)  context.getBean("churchFeedingDialog", cityProxy);
        case CHURCH_GIFT:
            return (ChurchGiftDialog)  context.getBean("churchGiftDialog", cityProxy);
        case CHURCH_EXTENSION:
            return (ChurchExtensionDialog)  context.getBean("churchExtensionDialog", cityProxy);
        case SHIP_CONVOY:
            return (ConvoyDialog)context.getBean("convoyDialog", cityProxy);
        case GUILD_JOIN:
            return (JoinGuildDialog)context.getBean("joinGuildDialog", cityProxy);
        case GUILD_MEMBERS:
            return (GuildMembersDialog)context.getBean("guildMembersDialog", cityProxy);
        case GUILD_AUCTION:
            return (AuctionGuildDialog)context.getBean("auctionGuildDialog", cityProxy);
        case GUILD_MEDITERREAN:
            return (GuildMediterraneanMapDialog)context.getBean("guildMediterraneanMapDialog", cityProxy);
        case GUILD_TRADE_AGREEMENT:
            return (GuildTradeAgreementDialog)context.getBean("guildTradeAgreementDialog", cityProxy);
        case CITY_HISTORY:
            String resourceName = getHistoryResourceName(cityProxy.getCity().getNameTemplate());
            HistoryStandaloneDialog dialog =  getHistoryDialog(cityProxy, resourceName);
            return dialog;
        default:
			throw new RuntimeException("Not yet implemented: "+dialogType);
		}
	}

    /**
     * Factory method for dialogs that are created with their own specific state.
     * @param state
     * @return
     */
	public CloseButtonDialog getDialog(IDialogState state) {
	    return (CloseButtonDialog) context.getBean(state.getDialogBeanName(), state);
    }

    public Dialog getDialog(EDialogType dialogType, ICityPlayerProxyJFX cityProxy, IConvoy convoy, IShip ship) {
        switch (dialogType) {
            case LEAVE_CONVOY:
                return (LeaveConvoyDialog) context.getBean("leaveConvoyDialog", cityProxy, convoy, ship);
            default:
                throw new RuntimeException("Not yet implemented: "+dialogType);
        }
    }

        /**
         * Retrieve the dialog that matches the side room person
         * @param sideRoomPerson
         * @return
         */
    private Dialog createDialogForSideRoom(ISideRoomPerson sideRoomPerson, ICityPlayerProxyJFX cityProxy) {
        if (sideRoomPerson instanceof ICourier) {
            return (TavernCourierDialog) context.getBean("tavernCourierDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IThieve) {
            return (TavernBurglarDialog) context.getBean("tavernBurglarDialog", cityProxy);
        }
        if (sideRoomPerson instanceof ITransportTrader) {
            return (TavernTransportTraderDialog) context.getBean("tavernTransportTraderDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IWarehouseTenant) {
            return (TavernWarehouseTenantDialog) context.getBean("tavernWarehouseTenantDialog", cityProxy);
        }
        if (sideRoomPerson instanceof ISmuggler) {
            return (TavernSmugglerDialog) context.getBean("tavernSmugglerDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IPirateHunter) {
            return (TavernPirateHunterDialog) context.getBean("tavernPirateHunterDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IPatrol) {
            return (TavernPatrolDialog) context.getBean("tavernPatrolDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IBuyer) {
            return (TavernBuyerDialog) context.getBean("tavernBuyerDialog", cityProxy);
        }
        if (sideRoomPerson instanceof  IConcurrent) {
            return (TavernConcurrentDialog) context.getBean("tavernConcurrentDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IEscorte) {
            return (TavernEscortDialog) context.getBean("tavernEscortDialog", cityProxy);
        }
        if (sideRoomPerson instanceof IFugitive) {
            return (TavernFugativeDialog) context.getBean("tavernFugativeDialog", cityProxy);
        }
        if (sideRoomPerson instanceof ITreasureMapOwner) {
            return (TavernTreasureMapOwnerDialog) context.getBean("tavernTreasureMapOwnerDialog", cityProxy);
        }
        throw new RuntimeException("Not yet implemented: "+sideRoomPerson.getClass().getName());

    }
}
