package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.ViewChangeEvent;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.graphic.javafx.display.MainGameView;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Nov 19, 2016
 */
public abstract class AbstractMarketPlaceBuildingPolygonInitializer extends ScenePolygonInitialzer {
    @Autowired
    private ClientViewState viewState;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;

    public AbstractMarketPlaceBuildingPolygonInitializer(String sceneName) {
        super(sceneName);
    }

    /**
     * Event to return to the marcet place scene.
     * @return
     */
    protected EventHandler<MouseEvent> createBackToMarketPlaceEvent() {
        return event -> {
            ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.MAIN_VIEW_MARKET);
            clientEventBus.post(new ViewChangeEvent(MainGameView.class, proxy));
            proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_HIDE);
            clientEventBus.post(new NoticeBoardUpdate(proxy));
        };
    }
}
