package ch.sahits.game.graphic.display.gameplay.internal;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.DependentInitialisation;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.util.StartNewGameBean;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

/**
 * Event handler for the city hall scene.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Jan 03, 2015
 */
@Component
@Lazy
@DependentInitialisation(StartNewGameBean.class)
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class ChurchScenePolygonInitializer extends AbstractMarketPlaceBuildingPolygonInitializer {

    public ChurchScenePolygonInitializer() {
        super("images/scene/churchInterior");
    }

    @Override
    protected EventHandler<MouseEvent> createEventHandler(String name) {
        switch (name) {
            case "Floor" : {
                return createBackToMarketPlaceEvent();
            }
            default:
                throw new IllegalStateException("Unhandled polygon action: "+name);
        }

    }
}
