package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import org.joda.time.DateTime;

/**
 * Timed task for the reputation update after a church feeding
 * Created by andi on 26.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class ChurchFeedingReputationUpdateTimedTask extends TimedTask {

    private ICity city;
    private IPlayer player;
    private int amountBeggers;

    public ChurchFeedingReputationUpdateTimedTask(ICity city, IPlayer player, int amountBeggers, DateTime deadline) {
        this.city = city;
        this.player = player;
        this.amountBeggers = amountBeggers;
        setExecutionTime(deadline);
    }

    @Override
    public void run() {
        city.getReputation(player).update(7*amountBeggers);

    }
}
