package ch.sahits.game.graphic.event.task;

import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.people.IWarehouseTenant;
import org.joda.time.DateTime;

/**
 * Timed task for the warehouse tenant removing the wares from the warehouse.
 * Created by andi on 26.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class WarehouseTenantPayTimedTask extends TimedTask {
    private IPlayer player;
    private IWarehouseTenant tenant;

    public WarehouseTenantPayTimedTask(IPlayer player, IWarehouseTenant tenant, DateTime deadLine) {
        this.player = player;
        this.tenant = tenant;
        setExecutionTime(deadLine);
    }

    @Override
    public void run() {
        player.getCompany().updateCash(tenant.getRentPerWeek());

    }
}
