/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.event.handler.impl;

import ch.sahits.game.event.data.CourierPatrolStateInternal;
import ch.sahits.game.event.data.ShipEntersPortEvent;
import ch.sahits.game.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.Optional;
import java.util.Random;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class NextCourierPatrolStation
extends ShipEntersPortEventListener {
    private final CourierPatrolStateInternal state;
    private final IPlayer player;
    private final DateTime deadline;
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private ClientTaskFactory taskFactory;
    @Autowired
    private Random rnd;
    @Autowired
    @Qualifier(value="clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public NextCourierPatrolStation(IShip ship, ICity city, CourierPatrolStateInternal state, IPlayer player, DateTime deadline) {
        super((INavigableVessel)ship, city);
        this.state = state;
        this.player = player;
        this.deadline = deadline;
        state.removeFirstCity();
    }

    @PostConstruct
    private void initializeEventBus() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregisterEventBus() {
        this.clientServerEventBus.unregister((Object)this);
    }

    public void handleShipEntersPort(ShipEntersPortEvent event) {
        super.handleShipEntersPort(event);
        DateTime now = this.date.getCurrentDate();
        if (now.isAfter((ReadableInstant)this.deadline)) {
            this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.unreliable", new Object[0]));
            ((IShip)this.getShip()).leavePassanger();
            this.clientServerEventBus.unregister((Object)this);
        }
    }

    public boolean execute() {
        Optional<ICity> nextCity = this.state.nextDestination();
        if (!nextCity.isPresent()) {
            int premium = this.state.getPremium();
            this.player.getCompany().updateCash((long)premium);
            ((IShip)this.getShip()).leavePassanger();
            this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.event.handler.impl.NextCourierPatrolStation.salary", new Object[]{premium}));
            this.unregisterEventBus();
        } else {
            ICity next = nextCity.get();
            this.state.removeFirstCity();
            int minutes = this.rnd.nextInt(600);
            DateTime postMessage = this.date.getCurrentDate().plusMinutes(minutes);
            this.taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.event.handler.impl.NextCourierPatrolStation.nextStation", next.getName());
            DateTime deadline = this.date.getCurrentDate().plusDays(6);
            new NextCourierPatrolStation((IShip)this.getShip(), this.state.nextDestination().get(), this.state, this.player, deadline);
        }
        return true;
    }
}

