/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.ShipFactory;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.people.IShipOwner;
import ch.sahits.game.openpatrician.model.ship.EShipUpgrade;
import ch.sahits.game.openpatrician.model.ship.ICrayer;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.model.weapon.IWeapon;
import javafx.event.EventHandler;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class CheatKeyEventListener
implements EventHandler<KeyEvent> {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private ClientViewState viewState;
    private ApplicationContext context;
    private boolean cheatModeActive = false;

    public void handle(KeyEvent event) {
        if (event.getCode().equals((Object)KeyCode.F10)) {
            this.cheatModeActive = !this.cheatModeActive;
            this.logger.debug("Toggle cheatmode. Cheat active: {}", new Object[]{this.cheatModeActive});
        } else if (this.cheatModeActive && event.isControlDown()) {
            INavigableVessel vessel;
            if (event.getCode().equals((Object)KeyCode.S)) {
                IHumanPlayer player = this.viewState.getPlayer();
                ICity city = this.viewState.getCurrentCityProxy().get().getCity();
                ShipFactory shipFactory = (ShipFactory)this.context.getBean(ShipFactory.class);
                ICrayer ship = shipFactory.createCrayer("Cheat ship name", EShipUpgrade.LEVEL1, 350);
                player.addShip((IShip)ship);
                player.addSelectableVessel((INavigableVessel)ship);
                ship.setOwner((IShipOwner)player);
                ship.setLocation(city.getCoordinates());
                this.viewState.getCurrentCityProxy().get().arrive((INavigableVessel)ship);
                this.logger.debug("Cheat created a new ship in " + city.getName());
            }
            if (event.getCode().equals((Object)KeyCode.W) && (vessel = this.viewState.getCurrentCityProxy().get().getActiveShip()) instanceof IShip) {
                IShip ship = (IShip)vessel;
                ship.move((IWeapon)EWeapon.CANNON, 1);
                this.logger.debug("Cheated one cannon onto the active ship: " + ship.getName());
            }
        }
    }

    public void setViewState(ClientViewState viewState) {
        this.viewState = viewState;
    }

    public void setContext(ApplicationContext context) {
        this.context = context;
    }
}

