/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display;

import ch.sahits.game.event.EGameStatusChange;
import ch.sahits.game.event.GameStateChange;
import ch.sahits.game.graphic.display.CheatKeyEventListener;
import ch.sahits.game.graphic.display.SceneChangeable;
import ch.sahits.game.graphic.display.scene.StartupScene;
import ch.sahits.game.javafx.OpenPatricianScene;
import ch.sahits.game.javafx.event.AggregateEventHandler;
import ch.sahits.game.javafx.event.CloseApplicationEventHandler;
import ch.sahits.game.javafx.event.MouseClickLocationEventHandler;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.server.ServerLauncher;
import ch.sahits.game.openpatrician.util.GamePropertyUtility;
import ch.sahits.game.util.UIFactory;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.io.IOException;
import java.net.URL;
import javafx.application.Application;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.ImageCursor;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

@ClassCategory(value={EClassCategory.STARTUP})
public final class OpenPaticianApplicationWindow
extends Application
implements SceneChangeable {
    private final Logger logger = LogManager.getLogger(this.getClass());
    private GamePropertyUtility gamePropertyUtility;
    public static final int MIN_WIDTH = 1074;
    public static final int MIN_HEIGHT = 766;
    private int width;
    private int height;
    private boolean fullscreen;
    private Stage primaryStage;
    private final AggregateEventHandler<KeyEvent> keyEventHandlerAggregate;
    private final MouseClickLocationEventHandler mouseClickEventHandler;
    private static OpenPaticianApplicationWindow instance;
    private ApplicationContext context;

    public OpenPaticianApplicationWindow() {
        Preconditions.checkState((instance == null ? 1 : 0) != 0, (Object)"Application should only be initialized once.");
        this.width = 1074;
        this.height = 766;
        this.fullscreen = false;
        this.keyEventHandlerAggregate = new AggregateEventHandler();
        CloseApplicationEventHandler closeEventHandler = new CloseApplicationEventHandler();
        this.mouseClickEventHandler = new MouseClickLocationEventHandler();
        EventHandler fullScreenEventHandler = event -> {
            if (event.getCode().equals((Object)KeyCode.F) && event.isControlDown()) {
                this.updateFullscreenMode();
            }
        };
        this.keyEventHandlerAggregate.addEventHandler((EventHandler)closeEventHandler);
        this.keyEventHandlerAggregate.addEventHandler(fullScreenEventHandler);
        instance = this;
    }

    public static SceneChangeable getApplication() {
        return instance;
    }

    public void start(Stage primaryStage) throws Exception {
        this.primaryStage = primaryStage;
        this.primaryStage.setMinWidth(1074.0);
        this.primaryStage.setMinHeight(766.0);
        this.context = ServerLauncher.getClientServerContext();
        UIFactory uiFactory = (UIFactory)this.context.getBean(UIFactory.class);
        StartupScene startupS = uiFactory.getStartupScene();
        Scene defaultScene = new Scene((Parent)startupS.getRoot(), (double)this.width, (double)this.height);
        defaultScene.getStylesheets().add((Object)"/styles/font.css");
        this.gamePropertyUtility = (GamePropertyUtility)this.context.getBean(GamePropertyUtility.class);
        this.fullscreen = Boolean.valueOf((String)this.gamePropertyUtility.getProperties().get("window.fullscreen"));
        startupS.setSceneChangeable(this);
        defaultScene.setOnMousePressed((EventHandler)this.mouseClickEventHandler);
        defaultScene.setOnKeyPressed(this.keyEventHandlerAggregate);
        try {
            CheatKeyEventListener cheatListener = (CheatKeyEventListener)this.context.getBean(CheatKeyEventListener.class);
            if (cheatListener != null) {
                this.keyEventHandlerAggregate.addEventHandler((EventHandler)cheatListener);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(defaultScene);
        primaryStage.setFullScreen(this.fullscreen);
        primaryStage.setFullScreenExitHint("");
        primaryStage.setTitle("OpenPatrician");
        primaryStage.setScene(defaultScene);
        primaryStage.show();
    }

    private void setCursor(Scene scene) {
        URL url = this.getClass().getResource("/icons/64/cursor.png");
        try {
            Image img = new Image(url.openStream());
            scene.setCursor((Cursor)new ImageCursor(img));
        }
        catch (IOException e) {
            this.logger.warn("Failed to load cursor icon from {}", new Object[]{url});
        }
    }

    @Override
    public void changeScene(OpenPatricianScene scene) {
        this.primaryStage.getScene().setOnMousePressed((EventHandler)this.mouseClickEventHandler);
        this.primaryStage.getScene().setOnKeyPressed(this.keyEventHandlerAggregate);
        this.primaryStage.getScene().setRoot((Parent)scene.getRoot());
    }

    public void updateFullscreenMode() {
        this.fullscreen = !this.fullscreen;
        this.primaryStage.setFullScreen(this.fullscreen);
    }

    public static void startClientUI(String[] args) {
        OpenPaticianApplicationWindow.launch((String[])args);
    }

    @Override
    public double getSceneWidth() {
        return this.primaryStage.getScene().getWidth();
    }

    @Override
    public double getSceneHeight() {
        return this.primaryStage.getScene().getHeight();
    }

    public void stop() throws Exception {
        System.out.println("Stopping the UI Application");
        this.stopUIApplicationContext();
        super.stop();
    }

    private void stopUIApplicationContext() {
        AsyncEventBus eventBus = (AsyncEventBus)this.context.getBean("serverClientEventBus");
        eventBus.post((Object)new GameStateChange(EGameStatusChange.SHUTDOWN));
        ((AbstractApplicationContext)this.context).close();
    }
}

