/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.graphic.image.impl.SelectiveCachableXMLImageLoader;
import ch.sahits.game.javafx.control.BaleAmountAlwaysVisible;
import ch.sahits.game.javafx.control.BarrelAmountAlwaysVisible;
import ch.sahits.game.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.UniquePrototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.building.ETradeType;
import ch.sahits.game.openpatrician.model.building.IAutomatedTrading;
import ch.sahits.game.openpatrician.model.building.ISteward;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.impl.Steward;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@UniquePrototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class AutomaticTradingOverviewDialog
extends TabelViewDialog {
    private final ETradeType[] types = new ETradeType[]{ETradeType.NONE, ETradeType.OFFICE_CITY, ETradeType.CITY_OFFICE};
    @Autowired
    @Qualifier(value="xmlImageLoader")
    private SelectiveCachableXMLImageLoader imageLoader;
    @Autowired
    @Qualifier(value="clientEventBus")
    private AsyncEventBus clientEventBus;
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;

    public AutomaticTradingOverviewDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeTitle() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.automatic.trading", new Object[0], this.locale.getCurrentLocal()));
    }

    @Override
    public void executeOnCloseButtonClicked() {
        this.clientEventBus.post((Object)new NoticeBoardClose());
        super.executeOnCloseButtonClicked();
    }

    @PostConstruct
    private void initializeModelAndDialog() {
        Table model = this.createModel();
        if (model != null) {
            this.setModel(model);
        }
        Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)"Ther must be a trading office present.");
        ITradingOffice office = (ITradingOffice)optOffice.get();
        HBox box = new HBox();
        box.setSpacing(15.0);
        box.setLayoutX(30.0);
        box.setLayoutY(627.0);
        Text label = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.office.manager", new Object[0], this.locale.getCurrentLocal()));
        label.getStyleClass().add((Object)"dialogText");
        box.getChildren().add((Object)label);
        OpenPatricianLargeWaxButton hireButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.hire", new Object[0], this.locale.getCurrentLocal()));
        hireButton.getStyleClass().add((Object)"actionButton");
        hireButton.textProperty().bind((ObservableValue)new HireButtonTextBinding(office));
        hireButton.onActionProperty().bind((ObservableValue)new HireActionBinding(office));
        box.getChildren().add((Object)hireButton);
        this.getContent().add((Object)box);
    }

    private Table createModel() {
        ITradingOffice office;
        Optional steward;
        Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
        if (optOffice.isPresent() && (steward = (office = (ITradingOffice)optOffice.get()).getSteward()).isPresent()) {
            return this.createAutomaticTradingModel();
        }
        return null;
    }

    private Table createAutomaticTradingModel() {
        Optional optOffice = this.city.getPlayer().findTradingOffice(this.city.getCity());
        Preconditions.checkArgument((boolean)optOffice.isPresent(), (Object)"Trading office should be present.");
        Table model = new Table();
        TableHeader header = new TableHeader(10);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.amount", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(""));
        Image dontMove = this.imageLoader.getImage("icons/dontMoveOnShipIcon", 96.0, 48.0);
        ImageView headerIcon = new ImageView(dontMove);
        header.add((ITableCell)new ControlTableCell((Node)headerIcon));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.price", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(""));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.LEFT);
        header.setAligenment(2, HPos.LEFT);
        header.setAligenment(3, HPos.RIGHT);
        header.setAligenment(4, HPos.LEFT);
        header.setAligenment(5, HPos.LEFT);
        header.setAligenment(6, HPos.LEFT);
        header.setAligenment(7, HPos.LEFT);
        header.setAligenment(8, HPos.RIGHT);
        header.setAligenment(9, HPos.LEFT);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.LEFT);
        model.setAligenment(2, HPos.LEFT);
        model.setAligenment(3, HPos.RIGHT);
        model.setAligenment(4, HPos.LEFT);
        model.setAligenment(5, HPos.LEFT);
        model.setAligenment(6, HPos.LEFT);
        model.setAligenment(7, HPos.LEFT);
        model.setAligenment(8, HPos.RIGHT);
        model.setAligenment(9, HPos.LEFT);
        model.setColumnWidth(new Integer[]{60, 62, 24, 70, 24, 24, 24, 30, 70, 24});
        final IAutomatedTrading autoTrading = ((ITradingOffice)optOffice.get()).getOfficeTrading();
        Image minus = this.imageLoader.getImage("icons/minusIcon");
        Image plus = this.imageLoader.getImage("icons/plusIcon");
        final Image unchecked = this.imageLoader.getImage("images/waxseal_24x24");
        final Image checked = this.imageLoader.getImage("icons/waxseal_checked_icon");
        for (final EWare ware : EWare.values()) {
            BarrelAmountAlwaysVisible amount;
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            final ObjectProperty tradeType = autoTrading.tradingTypeProperty((IWare)ware);
            TradingSwitchObjectBinding iconBinding = new TradingSwitchObjectBinding((ObjectProperty<ETradeType>)tradeType);
            ImageView icon = new ImageView();
            icon.imageProperty().bind((ObservableValue)iconBinding);
            Label tradeTypeLbl = new Label("", (Node)icon);
            tradeTypeLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    ETradeType nextTradeType = (ETradeType)tradeType.get();
                    for (int i = 0; i < AutomaticTradingOverviewDialog.this.types.length; ++i) {
                        if (nextTradeType != AutomaticTradingOverviewDialog.this.types[i]) continue;
                        nextTradeType = AutomaticTradingOverviewDialog.this.types[(i + 1) % AutomaticTradingOverviewDialog.this.types.length];
                        break;
                    }
                    tradeType.set((Object)nextTradeType);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)tradeTypeLbl));
            Label reduceAmountLbl = new Label("", (Node)new ImageView(minus));
            reduceAmountLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.updateAmount((IWare)ware, -1);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)reduceAmountLbl));
            if (ware.isBarrelSizedWare()) {
                amount = new BarrelAmountAlwaysVisible();
                amount.amountProperty().bind((ObservableValue)autoTrading.amountProperty((IWare)ware).asString());
                row.add((ITableCell)new ControlTableCell((Node)amount));
            } else {
                amount = new BaleAmountAlwaysVisible();
                amount.amountProperty().bind((ObservableValue)autoTrading.amountProperty((IWare)ware).asString());
                row.add((ITableCell)new ControlTableCell((Node)amount));
            }
            Label increaseAmountLbl = new Label("", (Node)new ImageView(plus));
            increaseAmountLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.updateAmount((IWare)ware, 1);
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)increaseAmountLbl));
            ImageView checkedIcon = new ImageView();
            checkedIcon.imageProperty().bind((ObservableValue)new ObjectBinding<Image>(){
                {
                    super.bind(new Observable[]{autoTrading.movableToShipProperty((IWare)ware)});
                }

                protected Image computeValue() {
                    if (autoTrading.isMovableToShip((IWare)ware)) {
                        return unchecked;
                    }
                    return checked;
                }
            });
            Label checkedLbl = new Label("", (Node)checkedIcon);
            checkedLbl.setOnMouseReleased((EventHandler)new EventHandler<MouseEvent>(){

                public void handle(MouseEvent mouseEvent) {
                    autoTrading.setMovableToShip((IWare)ware, !autoTrading.isMovableToShip((IWare)ware));
                }
            });
            row.add((ITableCell)new ControlTableCell((Node)checkedLbl));
            Text priceTypeText = new Text(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.min", new Object[0], this.locale.getCurrentLocal()));
            priceTypeText.getStyleClass().add((Object)"dialogText");
            priceTypeText.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)priceTypeText));
            Label decreasePriceLbl = new Label("", (Node)new ImageView(minus));
            decreasePriceLbl.setOnMouseReleased(mouseEvent -> autoTrading.updatePrice((IWare)ware, -1));
            decreasePriceLbl.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)decreasePriceLbl));
            CoinPriceAlwaysVisible price = new CoinPriceAlwaysVisible();
            price.amountProperty().bind((ObservableValue)autoTrading.priceProperty((IWare)ware).asString());
            price.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)price));
            Label increasePriceLbl = new Label("", (Node)new ImageView(plus));
            increasePriceLbl.setOnMouseReleased(mouseEvent -> autoTrading.updatePrice((IWare)ware, 1));
            increasePriceLbl.visibleProperty().bind((ObservableValue)new VisibleTradeTypeBinding(autoTrading.tradingTypeProperty((IWare)ware)));
            row.add((ITableCell)new ControlTableCell((Node)increasePriceLbl));
            model.add(row);
        }
        return model;
    }

    private class HireActionBinding
    extends ObjectBinding<EventHandler<MouseEvent>> {
        private final ITradingOffice office;

        private HireActionBinding(ITradingOffice office) {
            this.office = office;
            super.bind(new Observable[]{office.storageManagerPresentBinding()});
        }

        protected EventHandler<MouseEvent> computeValue() {
            if (this.office.storageManagerPresentBinding().get()) {
                return new EventHandler<MouseEvent>(){

                    public void handle(MouseEvent event) {
                        HireActionBinding.this.office.setSteward(null);
                        Table newModel = new Table();
                        AutomaticTradingOverviewDialog.this.setModel(newModel);
                    }
                };
            }
            return new EventHandler<MouseEvent>(){

                public void handle(MouseEvent event) {
                    HireActionBinding.this.office.setSteward((ISteward)new Steward());
                    Table newModel = AutomaticTradingOverviewDialog.this.createAutomaticTradingModel();
                    AutomaticTradingOverviewDialog.this.setModel(newModel);
                }
            };
        }
    }

    private class HireButtonTextBinding
    extends StringBinding {
        private final ITradingOffice office;

        private HireButtonTextBinding(ITradingOffice office) {
            this.office = office;
            super.bind(new Observable[]{office.storageManagerPresentBinding()});
        }

        protected String computeValue() {
            if (this.office.storageManagerPresentBinding().get()) {
                return AutomaticTradingOverviewDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.fire", new Object[0], AutomaticTradingOverviewDialog.this.locale.getCurrentLocal());
            }
            return AutomaticTradingOverviewDialog.this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.hire", new Object[0], AutomaticTradingOverviewDialog.this.locale.getCurrentLocal());
        }
    }

    private class VisibleTradeTypeBinding
    extends BooleanBinding {
        private final ObjectProperty<ETradeType> boundTradeType;

        private VisibleTradeTypeBinding(ObjectProperty<ETradeType> boundTradeType) {
            this.boundTradeType = boundTradeType;
            super.bind(new Observable[]{boundTradeType});
        }

        protected boolean computeValue() {
            return this.boundTradeType.get() != ETradeType.NONE;
        }
    }

    private class TradingSwitchObjectBinding
    extends ObjectBinding<Image> {
        private final ObjectProperty<ETradeType> boundTradeType;

        TradingSwitchObjectBinding(ObjectProperty<ETradeType> tradeTypeProperty) {
            super.bind(new Observable[]{tradeTypeProperty});
            this.boundTradeType = tradeTypeProperty;
        }

        protected Image computeValue() {
            switch ((ETradeType)this.boundTradeType.get()) {
                case NONE: {
                    return AutomaticTradingOverviewDialog.this.imageLoader.getImage("images/waxseal", 62.0, 24.0);
                }
                case CITY_OFFICE: {
                    return AutomaticTradingOverviewDialog.this.imageLoader.getImage("icons/townOutIcon", 62.0, 24.0);
                }
                case OFFICE_CITY: {
                    return AutomaticTradingOverviewDialog.this.imageLoader.getImage("icons/townInIcon", 62.0, 24.0);
                }
            }
            throw new IllegalArgumentException("Illegal trading type: " + this.boundTradeType.get());
        }
    }
}

