/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.TabelViewDialog;
import ch.sahits.game.graphic.display.dialog.action.BuyJFXProxyAction;
import ch.sahits.game.graphic.display.dialog.action.SellJFXProxyAction;
import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.graphic.display.dialog.util.impl.TransferableState;
import ch.sahits.game.javafx.control.BaleAmount;
import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.CoinPrice;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.model.ControlTableCell;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.javafx.model.ITableCell;
import ch.sahits.game.javafx.model.StaticTextTableCell;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.model.TableHeader;
import ch.sahits.game.javafx.model.TableRow;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.ComputablePriceV2;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.util.TransferUtil;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.binding.NumberBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public abstract class BaseTradeDialog
extends TabelViewDialog {
    private ObjectProperty<ETransferAmount> movableAmount = new SimpleObjectProperty((Object)ETransferAmount.ONE);
    protected final ICityPlayerProxyJFX city;
    @Autowired
    private TransferUtil transferUtil;
    @Autowired
    protected Locale locale;
    @Autowired
    private ModelTranslations translator;
    @Autowired
    protected MessageSource messageSource;
    @Autowired
    private ComputablePriceV2 computablePrice;
    private EDialogType type;

    public BaseTradeDialog(ICityPlayerProxyJFX city, EDialogType type) {
        this.city = city;
        this.type = type;
    }

    protected abstract Group createSubTitle(ICityPlayerProxyJFX var1);

    @PostConstruct
    private void initializeModelAndDialog() {
        Group subTitle = this.createSubTitle(this.city);
        subTitle.setLayoutX(30.0);
        subTitle.setLayoutY(80.0);
        this.getContent().add((Object)subTitle);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.title", new Object[0], this.locale.getCurrentLocal()));
        OpenPatricianSmallWaxButton btn1 = new OpenPatricianSmallWaxButton("1");
        btn1.setOnAction(arg0 -> this.movableAmount.setValue((Object)ETransferAmount.ONE));
        OpenPatricianSmallWaxButton btn5 = new OpenPatricianSmallWaxButton("5");
        btn5.setOnAction(arg0 -> this.movableAmount.setValue((Object)ETransferAmount.FIVE));
        String max = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.max", new Object[0], this.locale.getCurrentLocal());
        OpenPatricianSmallWaxButton btnMax = new OpenPatricianSmallWaxButton(max);
        btnMax.setOnAction(arg0 -> this.movableAmount.setValue((Object)ETransferAmount.MAX));
        this.addButtomControlButtons(btn1, btn5, btnMax);
        Table model = this.createModel(this.city);
        this.setModel(model);
    }

    private Table createModel(ICityPlayerProxyJFX cityProxy) {
        Table model = new Table();
        TableHeader header = new TableHeader(6);
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ware", new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.getTradeFromDestination()));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage(this.getFirstMoveActionHeaderTextKey(), new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage(this.getSecondMoveActionHeaderTextKey(), new Object[0], this.locale.getCurrentLocal())));
        header.add((ITableCell)new StaticTextTableCell(this.getTradeToDestination()));
        header.add((ITableCell)new StaticTextTableCell(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.avg-price", new Object[0], this.locale.getCurrentLocal())));
        header.setAligenment(0, HPos.RIGHT);
        header.setAligenment(1, HPos.RIGHT);
        header.setAligenment(2, HPos.CENTER);
        header.setAligenment(3, HPos.CENTER);
        header.setAligenment(4, HPos.RIGHT);
        header.setAligenment(5, HPos.RIGHT);
        model.setHeader(header);
        model.setAligenment(0, HPos.RIGHT);
        model.setAligenment(1, HPos.RIGHT);
        model.setAligenment(2, HPos.LEFT);
        model.setAligenment(3, HPos.LEFT);
        model.setAligenment(4, HPos.RIGHT);
        model.setAligenment(5, HPos.RIGHT);
        model.setColumnWidth(new Integer[]{100, 60, 72, 72, 60, 70});
        ICity city = cityProxy.getCity();
        Optional optOffice = cityProxy.getPlayer().findTradingOffice(city);
        INavigableVessel ship = cityProxy.getActiveShip();
        for (EWare ware : EWare.values()) {
            TableRow row = new TableRow();
            row.add((ITableCell)new StaticTextTableCell(this.translator.getLocalDisplayName(ware)));
            ReadOnlyIntegerProperty amountAvailableProp = this.getAvailableAmountProperty(city, (IWare)ware, optOffice);
            IntegerBinding amountToTransfer = this.getAmountProperty(city.getWare((IWare)ware).amountProperty());
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount();
                barrelAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount();
                baleAmount.amountProperty().bind((ObservableValue)amountAvailableProp.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            OpenPatricianSmallWaxButton buyBtn = new OpenPatricianSmallWaxButton("");
            buyBtn.textProperty().bind((ObservableValue)this.buyPrice((IWare)ware, amountAvailableProp, amountToTransfer));
            buyBtn.setOnAction(arg0 -> new BuyJFXProxyAction((IWare)ware, this.createTransferable()).run());
            row.add((ITableCell)new ControlTableCell((Node)buyBtn));
            OpenPatricianSmallWaxButton sellBtn = new OpenPatricianSmallWaxButton("");
            sellBtn.textProperty().bind((ObservableValue)this.sellPrice((IWare)ware, amountAvailableProp, amountToTransfer));
            sellBtn.setOnAction(arg0 -> new SellJFXProxyAction((IWare)ware, this.createTransferable()).run());
            row.add((ITableCell)new ControlTableCell((Node)sellBtn));
            ReadOnlyIntegerProperty storedAmountProperty = this.getStoredAmountProperty((IWare)ware, ship, optOffice);
            if (ware.isBarrelSizedWare()) {
                BarrelAmount barrelAmount = new BarrelAmount();
                barrelAmount.amountProperty().bind((ObservableValue)storedAmountProperty.asString());
                row.add((ITableCell)new ControlTableCell((Node)barrelAmount));
            } else {
                BaleAmount baleAmount = new BaleAmount();
                baleAmount.amountProperty().bind((ObservableValue)storedAmountProperty.asString());
                row.add((ITableCell)new ControlTableCell((Node)baleAmount));
            }
            CoinPrice coinPrice = new CoinPrice();
            AmountablePrice<IWare> amountable = this.getStoredAmountablePrice((IWare)ware, ship, optOffice);
            final NumberBinding avgPriceProperty = amountable.avgPriceProperty();
            StringBinding avgPriceStringBinding = new StringBinding(){
                {
                    super.bind(new Observable[]{avgPriceProperty});
                }

                protected String computeValue() {
                    return String.valueOf((int)Math.rint(avgPriceProperty.doubleValue()));
                }
            };
            coinPrice.amountProperty().bind((ObservableValue)avgPriceStringBinding);
            row.add((ITableCell)new ControlTableCell((Node)coinPrice));
            model.add(row);
        }
        return model;
    }

    private ITransferableJFX createTransferable() {
        return TransferableState.builder().city(this.city.getCity()).vessel(this.city.getActiveShip()).player((IPlayer)this.city.getPlayer()).dialogType(this.getDialogType()).movableAmount((ETransferAmount)this.movableAmount.get()).build();
    }

    protected String getSecondMoveActionHeaderTextKey() {
        return "ch.sahits.game.graphic.display.dialog.BaseTradeDialog.sell";
    }

    protected String getFirstMoveActionHeaderTextKey() {
        return "ch.sahits.game.graphic.display.dialog.BaseTradeDialog.buy";
    }

    protected String getTradeFromDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.city", new Object[0], this.locale.getCurrentLocal());
    }

    protected String getTradeToDestination() {
        return this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.BaseTradeDialog.ship", new Object[0], this.locale.getCurrentLocal());
    }

    private ReadOnlyIntegerProperty getStoredAmountProperty(IWare ware, INavigableVessel ship, Optional<ITradingOffice> office) {
        AmountablePrice<IWare> amounable = this.getStoredAmountablePrice(ware, ship, office);
        return amounable.amountProperty();
    }

    private AmountablePrice<IWare> getStoredAmountablePrice(IWare ware, INavigableVessel ship, Optional<ITradingOffice> office) {
        AmountablePrice amounable;
        switch (this.type) {
            case PORT_CITY_TO_SHIP: 
            case PORT_STORAGE_TO_SHIP: {
                amounable = ship.getWare(ware);
                break;
            }
            case PORT_CITY_TO_STORAGE: {
                if (office.isPresent()) {
                    amounable = office.get().getWare(ware);
                    break;
                }
                amounable = new AmountablePrice(0, 0.0);
                break;
            }
            default: {
                throw new IllegalStateException("Dialog type " + this.type + " not handled");
            }
        }
        return amounable;
    }

    private ReadOnlyIntegerProperty getAvailableAmountProperty(ICity city, IWare ware, Optional<ITradingOffice> office) {
        AmountablePrice available;
        switch (this.type) {
            case PORT_CITY_TO_SHIP: 
            case PORT_CITY_TO_STORAGE: {
                available = city.getWare(ware);
                break;
            }
            default: {
                available = office.isPresent() ? office.get().getWare(ware) : new AmountablePrice(0, 0.0);
            }
        }
        return available.amountProperty();
    }

    private StringBinding buyPrice(final IWare ware, final ReadOnlyIntegerProperty availableAmount, final IntegerBinding amountToBuy) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{availableAmount, amountToBuy});
            }

            protected String computeValue() {
                switch (BaseTradeDialog.this.type) {
                    case PORT_CITY_TO_SHIP: 
                    case PORT_CITY_TO_STORAGE: {
                        if (availableAmount.get() > 0) {
                            return String.valueOf(BaseTradeDialog.this.computablePrice.buyPrice((ITradable)ware, availableAmount, amountToBuy));
                        }
                        return "0";
                    }
                }
                return "<";
            }
        };
    }

    private StringBinding sellPrice(final IWare ware, final ReadOnlyIntegerProperty availableAmount, final IntegerBinding amountToSell) {
        return new StringBinding(){
            {
                super.bind(new Observable[]{availableAmount, amountToSell});
            }

            protected String computeValue() {
                switch (BaseTradeDialog.this.type) {
                    case PORT_CITY_TO_SHIP: 
                    case PORT_CITY_TO_STORAGE: {
                        if (BaseTradeDialog.this.movableAmount.get() == ETransferAmount.MAX) {
                            return String.valueOf(ware.getMaxValueSell());
                        }
                        if (amountToSell.get() > 0) {
                            return String.valueOf(BaseTradeDialog.this.computablePrice.sellPrice((ITradable)ware, availableAmount, amountToSell));
                        }
                        return String.valueOf(ware.getMaxValueSell());
                    }
                }
                return ">";
            }
        };
    }

    private IntegerBinding getAmountProperty(final ReadOnlyIntegerProperty maxAmount) {
        return new IntegerBinding(){
            {
                super.bind(new Observable[]{BaseTradeDialog.this.movableAmount, maxAmount});
            }

            protected int computeValue() {
                return BaseTradeDialog.this.transferUtil.calculateAvailableAmount(BaseTradeDialog.this.movableAmount, maxAmount.get());
            }
        };
    }

    public EDialogType getDialogType() {
        return this.type;
    }
}

