/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog;

import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

public abstract class DefaultSimpleDialog
extends CloseButtonDialog {
    @Autowired
    private DialogUtil dialogHelper;
    @Autowired
    protected MessageSource messageSource;
    @Autowired
    protected Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    private final VBox box = new VBox();

    public DefaultSimpleDialog() {
        this(false);
    }

    public DefaultSimpleDialog(boolean withoutTitle) {
        this.box.setLayoutX(30.0);
        if (withoutTitle) {
            this.box.setLayoutY(47.0);
        } else {
            this.box.setLayoutY(127.0);
        }
        this.getContent().add((Object)this.box);
    }

    public DefaultSimpleDialog(int spacing) {
        this(false);
        this.box.setSpacing((double)spacing);
    }

    public DecoratedText addDecoratedText(String textKey, String id, Object ... textParameters) {
        String template = this.messageSource.getMessage(textKey, textParameters, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        this.addNode((Node)text, id);
        return text;
    }

    public void addNode(Node node, String id) {
        this.box.getChildren().add((Object)node);
        if (id != null) {
            node.setId(id);
        } else {
            node.setId("");
        }
    }

    public void addDecoratedText(String textKey, String id, Pos alignment, Object ... textParameters) {
        String template = this.messageSource.getMessage(textKey, textParameters, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        this.addNode((Node)text, id, alignment);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addNode(Node node, String id, Pos alignment) {
        if (alignment == Pos.CENTER_LEFT) {
            this.addNode(node, id);
            return;
        }
        if (id != null) {
            node.setId(id);
        } else {
            node.setId("");
        }
        if (node instanceof Pane) {
            if (alignment == Pos.CENTER) {
                this.addNode((Node)this.dialogHelper.center((Pane)node), null);
                return;
            } else {
                if (alignment != Pos.CENTER_RIGHT) throw new IllegalArgumentException("Alignment '" + alignment + "' is not supported");
                this.addNode((Node)this.dialogHelper.right((Pane)node), null);
            }
            return;
        } else {
            if (!(node instanceof Control)) throw new IllegalArgumentException("Can only add Panes and Controlls in a layouted form");
            if (alignment == Pos.CENTER) {
                this.addNode((Node)this.dialogHelper.center((Control)node), null);
                return;
            } else {
                if (alignment != Pos.CENTER_RIGHT) throw new IllegalArgumentException("Alignment '" + alignment + "' is not supported");
                this.addNode((Node)this.dialogHelper.right((Control)node), null);
            }
        }
    }

    public void addVerticalSpacer(int heigth) {
        this.box.getChildren().add((Object)this.dialogHelper.createVerticalSpacer(heigth));
    }

    public OpenPatricianLargeWaxButton addActionButton(String textKey, String id) {
        OpenPatricianLargeWaxButton button = new OpenPatricianLargeWaxButton(this.messageSource.getMessage(textKey, new Object[0], this.locale.getCurrentLocal()));
        button.setId(id);
        int actionButtonX = 197;
        button.setLayoutX(197.0);
        button.setLayoutY(603.0);
        this.getContent().add((Object)button);
        return button;
    }

    public void clearContent() {
        this.box.getChildren().clear();
    }

    public void remove(Node node) {
        this.box.getChildren().remove((Object)node);
    }
}

