/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.javafx.bindings.ConstantIntegerBinding;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.product.ETransferAmount;
import ch.sahits.game.openpatrician.model.product.ITradable;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.model.ship.IShip;
import java.util.Map;
import javafx.beans.binding.IntegerBinding;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;

@ClassCategory(value={EClassCategory.HANDLER})
class Ship2CityJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;

    public Ship2CityJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        INavigableVessel vessel = this.transfer.getVessel();
        int amountOnShip = vessel.getWare(this.ware).getAmount();
        if (amountOnShip > 0) {
            ICity city = this.transfer.getCity();
            int availableAmountCity = city.getWare(this.ware).getAmount();
            int amount2Move = this.transfer.getAmount(amountOnShip);
            int avgPrice = this.transfer.getMovableAmount() == ETransferAmount.MAX ? this.ware.getMaxValueSell() : this.transfer.getComputablePrice().sellPrice((ITradable)this.ware, (ReadOnlyIntegerProperty)new SimpleIntegerProperty(availableAmountCity), (IntegerBinding)new ConstantIntegerBinding(amount2Move));
            IPlayer player = this.transfer.getPlayer();
            city.move(this.ware, amount2Move, (ICitizen)player);
            int sold = vessel.unload(this.ware, -amount2Move);
            if (vessel instanceof IShip) {
                player.getCompany().updateCash((long)(avgPrice * sold));
            } else {
                IConvoy convoy = (IConvoy)vessel;
                Map capacityMap = convoy.getCapacityPerOwner();
                long totalCash = avgPrice * sold;
                double totalCapacity = convoy.getCapacity();
                for (Map.Entry entry : capacityMap.entrySet()) {
                    double percentage = (double)((Integer)entry.getValue()).intValue() / totalCapacity;
                    long partialAmount = Math.round((double)totalCash * percentage);
                    ((IPlayer)entry.getKey()).getCompany().updateCash(partialAmount);
                }
            }
        }
    }
}

