/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.action;

import ch.sahits.game.graphic.display.dialog.util.ITransferableJFX;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.util.Map;
import java.util.Optional;

@ClassCategory(value={EClassCategory.HANDLER})
class Ship2StorageJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;

    public Ship2StorageJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        INavigableVessel ship = this.transfer.getVessel();
        AmountablePrice amountable = ship.getWare(this.ware);
        int availableAmountShip = amountable.getAmount();
        IPlayer player = this.transfer.getPlayer();
        Optional optOffice = player.findTradingOffice(this.transfer.getCity());
        if (availableAmountShip > 0 && optOffice.isPresent()) {
            ITradingOffice office = (ITradingOffice)optOffice.get();
            int amount2Move = this.transfer.getAmount(availableAmountShip);
            int avgPrice = amountable.getAVGPrice();
            int moved = ship.unload(this.ware, amount2Move);
            office.move(this.ware, moved, avgPrice);
            if (ship instanceof IConvoy) {
                IConvoy convoy = (IConvoy)ship;
                Map capacityMap = convoy.getCapacityPerOwner();
                long totalCash = avgPrice * moved;
                double totalCapacity = convoy.getCapacity();
                for (Map.Entry entry : capacityMap.entrySet()) {
                    if (((IPlayer)entry.getKey()).equals(player)) continue;
                    double percentage = (double)((Integer)entry.getValue()).intValue() / totalCapacity;
                    long partialAmount = Math.round((double)totalCash * percentage);
                    ((IPlayer)entry.getKey()).getCompany().updateCash(partialAmount);
                    player.getCompany().updateCash(-partialAmount);
                }
            }
        }
    }
}

