/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.DowryState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class DowryDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private final DowryState state;

    public DowryDialog(DowryState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), letterDate});
        this.addVerticalSpacer(20);
        IShip ship = this.state.getShip();
        int loaded = ship.getLoadBinding().get();
        String shipType = this.modelTranslations.getLocalDisplayName(ship.getShipType());
        if (loaded > 0) {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.DowryDialog.dowry.filled", "dowryWithLoad", shipType, loaded);
        } else {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.DowryDialog.dowry.empty", "dowryWithoutLoad", shipType);
        }
    }
}

