/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.event;

import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.graphic.event.task.MarriageOfferTimedTask;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.MarriageBrokerAnnouncementState;
import ch.sahits.game.openpatrician.model.DateService;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import java.util.Random;
import javafx.geometry.Pos;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class MarriageBrokerAnnouncementDialog
extends DefaultSimpleDialog {
    private final MarriageBrokerAnnouncementState state;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private DateService dateService;
    @Autowired
    private TimedUpdatableTaskList taskList;
    @Autowired
    private Random rnd;
    @Autowired
    private ClientViewState clientViewState;
    @Autowired
    private ClientTaskFactory taskFactory;

    public MarriageBrokerAnnouncementDialog(MarriageBrokerAnnouncementState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String date = this.modelTranslations.toDisplayString(this.state.getDate());
        this.addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, new Object[]{this.state.getLocation(), date});
        this.addVerticalSpacer(20);
        if (this.state.isGenderMale()) {
            this.addDecoratedText("letter.salutation.male", "salutationMale", this.state.getToLastName());
        } else {
            this.addDecoratedText("letter.salutation.female", "salutationFemale", this.state.getToLastName());
        }
        this.addVerticalSpacer(20);
        if (this.state.isGenderMale()) {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.MarriageBrokerAnnouncementDialog.content.male", "contentMale", new Object[0]);
        } else {
            this.addDecoratedText("ch.sahits.game.graphic.display.dialog.event.MarriageBrokerAnnouncementDialog.content.female", "contentFemale", new Object[0]);
        }
        this.addVerticalSpacer(20);
        this.addDecoratedText("letter.feedback.14d", "deadline", new Object[0]);
        this.addVerticalSpacer(20);
        this.addDecoratedText("letter.greetings", "grettings", Pos.CENTER, new Object[0]);
        this.addDecoratedText("letter.fullname", "signature", Pos.CENTER_RIGHT, new Object[]{this.state.getFromFirstName(), this.state.getFromLastName()});
        DateTime decisionDeadline = this.state.getDate().plusDays(14);
        if (!this.dateService.isPast(decisionDeadline)) {
            OpenPatricianLargeWaxButton button = this.addActionButton("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", "acceptBtn");
            button.setOnAction(event -> {
                int delay = this.rnd.nextInt(50) + 24;
                DateTime deadLine = this.state.getDate().plusDays(delay);
                MarriageOfferTimedTask task = this.taskFactory.getMarriageOfferTask(this.clientViewState.getPlayer(), this.state, deadLine);
                this.taskList.add((TimedTask)task);
            });
        }
    }
}

