/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.guild;

import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.ItemNavigator;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.javafx.service.DecoratedTextFactory;
import ch.sahits.game.javafx.service.ItemNavigatorLabelWrapperFactory;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.TradingOfficeList;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.guild.GuildList;
import ch.sahits.game.openpatrician.model.city.guild.IGuild;
import ch.sahits.game.openpatrician.model.map.IMap;
import ch.sahits.game.openpatrician.model.personal.IPersonalData;
import ch.sahits.game.openpatrician.model.personal.ISpouseData;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javafx.beans.property.IntegerProperty;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class GuildMembersDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    private GuildList guildList;
    @Autowired
    private ItemNavigatorLabelWrapperFactory itemWrapperFactory;
    @Autowired
    private ModelTranslations modelTranslations;
    @Autowired
    private TradingOfficeList offices;
    @Autowired
    private Date date;
    @Autowired
    private IMap map;
    @Autowired
    private DialogUtil dialogHelper;
    private VBox box;

    public GuildMembersDialog(ICityPlayerProxyJFX city) {
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.title", new Object[0], this.locale.getCurrentLocal()));
        ICity city = this.city.getCity();
        IGuild guild = (IGuild)this.guildList.findGuild(city).get();
        if (guild.getMembers().isEmpty()) {
            String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.noMembers", new Object[]{city.getName()}, this.locale.getCurrentLocal());
            DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setId("noMembers");
            this.box = new VBox(new Node[]{text});
            this.box.setLayoutY(127.0);
            this.getContent().addAll((Object[])new Node[]{this.box});
        } else {
            List members = guild.getMembers();
            List wrappedList = this.itemWrapperFactory.createNonLabeledListForPlayer(members);
            ItemNavigator itemNavigator = new ItemNavigator(wrappedList);
            this.initializeContent((ItemNavigator<IPlayer>)itemNavigator);
            if (members.size() > 1) {
                Group centerPane = this.dialogHelper.center((Pane)itemNavigator);
                this.box.getChildren().addAll((Object[])new Node[]{this.dialogHelper.createVerticalSpacer(50), centerPane});
            }
        }
    }

    private void initializeContent(ItemNavigator<IPlayer> itemNavigator) {
        IntegerProperty currentPos = itemNavigator.currentPositionProperty();
        currentPos.addListener((observable, oldValue, newValue) -> {
            Iterator iterator = this.getContent().iterator();
            while (iterator.hasNext()) {
                Node node = (Node)iterator.next();
                if (!(node instanceof VBox)) continue;
                iterator.remove();
            }
            this.initializeContent(itemNavigator);
        });
        IPlayer member = (IPlayer)itemNavigator.getCurrent();
        Label header = new Label(member.getName() + " " + member.getLastName());
        header.getStyleClass().addAll((Object[])new String[]{"subTitle"});
        header.setId("playerName");
        Pane centerPane = this.dialogHelper.center((Control)header);
        this.box = new VBox(new Node[]{centerPane, new PlaceHolder(1.0, 10.0)});
        List offices = this.offices.findOwnedBy(member);
        ITradingOffice oldest = null;
        DateTime foundingDate = DateTime.now();
        for (ITradingOffice office : offices) {
            DateTime date = office.getEstablishedDate();
            if (!date.isBefore((ReadableInstant)foundingDate)) continue;
            foundingDate = date;
            oldest = office;
        }
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.summary", new Object[]{this.modelTranslations.getLocalDisplayName(member.getCareerLevel()), this.modelTranslations.getLocalDisplayName(member.getRank()), member.getName(), member.getLastName(), member.getHometown().getName(), this.modelTranslations.toDisplayString(foundingDate), oldest.getCity().getName()}, this.locale.getCurrentLocal());
        DecoratedText text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setId("summary");
        this.box.getChildren().add((Object)text);
        this.box.getChildren().add((Object)new PlaceHolder(1.0, 30.0));
        IPersonalData personalData = member.getPersonalData();
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.age", new Object[]{personalData.getAge(this.date.getCurrentDate())}, this.locale.getCurrentLocal());
        text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setId("age");
        this.box.getChildren().add((Object)text);
        if (member.getSpouseData().isPresent()) {
            ISpouseData spouseData = (ISpouseData)member.getSpouseData().get();
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.married", new Object[]{spouseData.getName(), spouseData.getLastName(), spouseData.getBirthPlace().getName()}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setId("married");
            this.box.getChildren().add((Object)text);
        } else {
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.notMarried", new Object[]{personalData.getAge(this.date.getCurrentDate())}, this.locale.getCurrentLocal());
            text = this.textFactory.createDecoratedText(template, new HashMap());
            text.setId("notMarried");
            this.box.getChildren().add((Object)text);
        }
        this.box.getChildren().add((Object)new PlaceHolder(1.0, 20.0));
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.details", new Object[]{offices.size(), member.getFleet().size()}, this.locale.getCurrentLocal());
        text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setId("details");
        this.box.getChildren().add((Object)text);
        List cities = this.map.getCities(member);
        ICity bestCity = this.city.getPlayer().getHometown();
        long reputation = 0L;
        for (ICity c : cities) {
            if ((long)c.getReputation(member).getPopularity() <= reputation) continue;
            bestCity = c;
            reputation = c.getReputation(member).getPopularity();
        }
        template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.guild.GuildMembersDialog.reputation", new Object[]{bestCity.getName()}, this.locale.getCurrentLocal());
        text = this.textFactory.createDecoratedText(template, new HashMap());
        text.setId("reputation");
        this.box.getChildren().add((Object)text);
        this.box.setLayoutX(50.0);
        this.box.setLayoutY(127.0);
        this.getContent().addAll((Object[])new Node[]{this.box});
    }
}

