/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.loaner;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ListType;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.ILoanProposal;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerTakeLoanDialog
extends DefaultSimpleDialog {
    public static final String DEFAULT_NON_SELECTED_STYLE = "-fx-fill: dimgray; -fx-text-fill: dimgray;";
    public static final String SELECTED_STYLE = "-fx-font-weight: bolder; -fx-fill: black;  -fx-text-fill: black;";
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private LoanerService loanerService;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=ILoanProposal.class)
    private ObjectProperty<ILoanProposal> selectedProposal = new SimpleObjectProperty(null);
    @ListType(value=Node.class)
    private List<Node> loans = new ArrayList<Node>();

    public LoanerTakeLoanDialog(ICityPlayerProxyJFX city) {
        super(false);
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        this.loaner = (LoanerState)this.loanerService.findLoaner(this.city.getCity());
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.notice.NoticeBoardFactory.takeLoan", new Object[0], this.locale.getCurrentLocal()));
        this.addDecoratedText("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.dialogSubheading", "introText", new Object[0]);
        for (ILoanProposal proposal : this.loaner.getLoanProposals()) {
            int amount = proposal.getAmount();
            int payback = (int)((double)amount * proposal.getInterest());
            int duration = proposal.getDurationInWeeks();
            String interest = String.format("%.1f", (proposal.getInterest() - 1.0) * 100.0);
            DecoratedText entry = this.addDecoratedText("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.loanProposal", "proposal", amount, duration, payback, interest);
            this.loans.add((Node)entry);
            entry.setOnMouseReleased(mouseEvent -> {
                this.selectedProposal.setValue((Object)proposal);
                this.deactivateAll();
                entry.applyStyle(SELECTED_STYLE);
            });
            entry.applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
        OpenPatricianLargeWaxButton acceptBtn = this.addActionButton("ch.sahits.game.graphic.display.dialog.LoanerTakeLoanDialog.btnLabel", "actionBtn");
        acceptBtn.setDisable(true);
        this.selectedProposal.addListener((observableValue, oldProposal, newProposal) -> {
            if (newProposal != null) {
                acceptBtn.setDisable(false);
            }
        });
        acceptBtn.setOnAction(this.createAcceptHandler());
    }

    private void deactivateAll() {
        for (Node node : this.loans) {
            if (!(node instanceof DecoratedText)) continue;
            ((DecoratedText)node).applyStyle(DEFAULT_NON_SELECTED_STYLE);
        }
    }

    private EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            ILoanProposal proposal = (ILoanProposal)this.selectedProposal.get();
            IHumanPlayer debitor = this.city.getPlayer();
            this.loanerService.takeOutLoan((ILoaner)this.loaner, proposal, (IPlayer)debitor, this.city.getCity());
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

