/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.graphic.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.graphic.event.task.ClientTaskFactory;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.product.EWare;
import java.util.HashMap;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernBuyerDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private TimedUpdatableTaskList timedTaskList;
    @Autowired
    private ClientTaskFactory taskFactory;
    @Autowired
    private ModelTranslations translator;

    public TavernBuyerDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getBuyer());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        IBuyer buyer = (IBuyer)this.currentPerson.get();
        int p = buyer.getAmountablePrice().getAVGPrice() * buyer.getAmountablePrice().getAmount();
        Object[] args = new Object[]{buyer.getName(), buyer.getAmountablePrice().getAmount(), this.translator.getLocalDisplayName((EWare)buyer.getWare()), p};
        String key = "ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.bale.dialog";
        if (buyer.getWare().isBarrelSizedWare()) {
            key = "ch.sahits.game.graphic.display.dialog.TavernBuyerDialog.barrel.dialog";
        }
        String loadedText = this.messageSource.getMessage(key, args, this.locale.getCurrentLocal());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, new HashMap());
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            IBuyer buyer = (IBuyer)this.currentPerson.get();
            this.timedTaskList.add((TimedTask)this.taskFactory.getBuyWares(this.city, buyer));
            buyer.leave();
            this.executeOnCloseButtonClicked();
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                return false;
            }
        };
    }
}

