/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.data.ClockTickDayChange;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.DialogUtil;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.FightingSkillAlwaysVisible;
import ch.sahits.game.javafx.control.NavigationSkillAlwaysVisible;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.control.TradingSkillAlwaysVisible;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.event.PersonLeavesTavernEvent;
import ch.sahits.game.openpatrician.model.people.ICaptain;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.impl.CaptainsState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import java.util.HashMap;
import java.util.Optional;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernCaptainDialog
extends CloseButtonDialog {
    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(value=IShip.class)
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private CaptainsState captainsState;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private ClientViewState viewState;
    private ICaptain captain;
    @Autowired
    private Locale locale;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientServerEventBus;
    @Autowired
    @Qualifier(value="timerEventBus")
    @XStreamOmitField
    private AsyncEventBus timerEventBus;
    @Autowired
    private MessageSource messageSource;
    private final TavernState tavernState;

    public TavernCaptainDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.currentShip = new SimpleObjectProperty((Object)this, "currentShip", null);
        if (city.getActiveShip() instanceof IShip) {
            IShip ship = (IShip)city.getActiveShip();
            this.currentShip.setValue((Object)ship);
        }
        this.tavernState = city.getCity().getCityState().getTavernState();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.captain = (ICaptain)this.captainsState.getCaptain(this.city.getCity()).get();
        Text intro = new Text();
        intro.getStyleClass().add((Object)"dialogText");
        intro.setWrappingWidth(458.0);
        intro.setLayoutX(30.0);
        intro.setLayoutY(100.0);
        intro.setText(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.dialog1", new Object[]{this.captain.getName()}, this.locale.getCurrentLocal()));
        this.getContent().add((Object)intro);
        GridPane pane1 = new GridPane();
        pane1.setLayoutX(30.0);
        pane1.setLayoutY(200.0);
        pane1.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(100.0), new ColumnConstraints(50.0), new ColumnConstraints(50.0), new ColumnConstraints(50.0)});
        String template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.age", new Object[]{this.captain.getAge()}, this.locale.getCurrentLocal());
        DecoratedText age = this.decoratedTextFactory.createDecoratedText(template, new HashMap());
        TradingSkillAlwaysVisible trading = new TradingSkillAlwaysVisible();
        NavigationSkillAlwaysVisible navigation = new NavigationSkillAlwaysVisible();
        FightingSkillAlwaysVisible fighting = new FightingSkillAlwaysVisible();
        trading.setAmount(Integer.valueOf(this.captain.getTradingSkillLevel()));
        navigation.setAmount(Integer.valueOf(this.captain.getNavigationSkillLevel()));
        fighting.setAmount(Integer.valueOf(this.captain.getFightSkillLevel()));
        pane1.add((Node)age, 0, 0);
        pane1.add((Node)trading, 1, 0);
        pane1.add((Node)navigation, 2, 0);
        pane1.add((Node)fighting, 3, 0);
        this.getContent().add((Object)pane1);
        FlowPane salery = new FlowPane(Orientation.HORIZONTAL);
        salery.setLayoutX(30.0);
        salery.setLayoutY(250.0);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.price", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("salary", this.captain.getSalary());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().add((Object)dt);
        if (this.currentShip.get() == null) {
            template = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernCaptainDialog.noShip", new Object[0], this.locale.getCurrentLocal());
            DecoratedText noShip = this.decoratedTextFactory.createDecoratedText(template, new HashMap());
            noShip.setLayoutX(30.0);
            noShip.setLayoutY(300.0);
            this.getContent().add((Object)noShip);
        } else {
            GridPane shipCatalogue = this.createShipCatalogue();
            this.getContent().add((Object)shipCatalogue);
            int actionButtonX = 197;
            OpenPatricianLargeWaxButton action = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.AutomaticTradingOverviewDialog.hire", new Object[0], this.locale.getCurrentLocal()));
            action.getStyleClass().add((Object)"actionButton");
            action.setOnAction(mouseEvent -> {
                ((IShip)this.currentShip.get()).setCaptain(this.captain);
                this.captainsState.hireCaptain(this.captain, this.city.getCity());
                this.clientServerEventBus.post((Object)new PersonLeavesTavernEvent(this.city.getCity(), (IPerson)this.captain));
                this.executeOnCloseButtonClicked();
            });
            action.setLayoutX(197.0);
            action.setLayoutY(603.0);
            BooleanBinding enableAction = new BooleanBinding(){

                protected boolean computeValue() {
                    IShip iShip = (IShip)TavernCaptainDialog.this.currentShip.get();
                    return iShip != null && !iShip.getCaptian().isPresent();
                }
            };
            action.setDisable(!enableAction.get());
            enableAction.addListener((observableValue, oldValue, newValue) -> action.setDisable(newValue == false));
            this.getContent().add((Object)action);
            this.timerEventBus.register((Object)this);
        }
    }

    private GridPane createShipCatalogue() {
        GridPane shipCatalogue = new GridPane();
        shipCatalogue.setLayoutX(30.0);
        shipCatalogue.setLayoutY(300.0);
        shipCatalogue.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{new ColumnConstraints(64.0), new ColumnConstraints(330.0), new ColumnConstraints(64.0)});
        BooleanBinding enablePrevNext = this.dialogUtil.enableShipCatalogueForShips(this.city);
        OpenPatricianSmallWaxButton prevShip = new OpenPatricianSmallWaxButton("<");
        prevShip.setOnAction(this.dialogUtil.createPreviousActionForShips(this.city, this.currentShip));
        prevShip.setDisable(!enablePrevNext.get());
        shipCatalogue.add((Node)prevShip, 0, 0);
        OpenPatricianSmallWaxButton nextShip = new OpenPatricianSmallWaxButton(">");
        nextShip.setOnAction(this.dialogUtil.createNextActionForShips(this.city, this.currentShip));
        nextShip.setDisable(!enablePrevNext.get());
        shipCatalogue.add((Node)nextShip, 2, 0);
        enablePrevNext.addListener((observableValue, oldValue, newValue) -> {
            nextShip.setDisable(newValue == false);
            prevShip.setDisable(newValue == false);
        });
        Text ship = new Text();
        ship.getStyleClass().add((Object)"dialogText");
        ship.textProperty().bind((ObservableValue)new StringBinding(){

            protected String computeValue() {
                return ((IShip)TavernCaptainDialog.this.currentShip.get()).getName();
            }
        });
        shipCatalogue.add((Node)ship, 1, 0);
        GridPane.setHalignment((Node)ship, (HPos)HPos.CENTER);
        return shipCatalogue;
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.timerEventBus.unregister((Object)this);
        this.tavernDialogUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }

    @Subscribe
    public void handleDayChange(ClockTickDayChange dayChange) {
        Optional captain = this.captainsState.getCaptain(this.city.getCity());
        if (!captain.isPresent()) {
            this.executeOnCloseButtonClicked();
        }
    }
}

