/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.tavern;

import ch.sahits.game.event.EViewChangeEvent;
import ch.sahits.game.event.IViewChangeEvent;
import ch.sahits.game.event.NoticeBoardUpdate;
import ch.sahits.game.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.dialog.CloseButtonDialog;
import ch.sahits.game.graphic.display.dialog.util.TavernDialogUtil;
import ch.sahits.game.graphic.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.javafx.control.DecoratedText;
import ch.sahits.game.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.javafx.util.ModelTranslations;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.annotation.Prototype;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.people.IPerson;
import ch.sahits.game.openpatrician.model.people.ITraveler;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.util.l10n.Locale;
import java.util.HashMap;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.scene.Node;
import javax.annotation.PostConstruct;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernTravelerDialog
extends CloseButtonDialog {
    @Autowired
    private TavernDialogUtil tavernUtil;
    @Autowired
    private Date date;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private ModelTranslations modelTranslator;
    private final ICityPlayerProxyJFX city;
    private final TavernState tavernState;
    private final ITraveler traveler;

    public TavernTravelerDialog(ICityPlayerProxyJFX city) {
        this.city = city;
        this.tavernState = city.getCity().getCityState().getTavernState();
        this.traveler = this.tavernState.getTraveler();
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTravelerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        IHumanPlayer player = this.city.getPlayer();
        DateTime arrivalDate = this.traveler.getArrivalDate();
        String d = this.modelTranslator.toDisplayString(arrivalDate);
        String loadedText = this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernTravelerDialog.dialog", new Object[]{this.city.getPlayer().getLastName(), this.modelTranslator.getLocalDisplayName(player.getCareerLevel()), player.getName(), this.traveler.getDestination().getName(), d}, this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", this.traveler.getPremium());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        OpenPatricianLargeWaxButton acceptButton = new OpenPatricianLargeWaxButton(this.messageSource.getMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.accept", new Object[0], this.locale.getCurrentLocal()));
        acceptButton.getStyleClass().add((Object)"actionButton");
        int BUTTON_X = 197;
        acceptButton.setLayoutX((double)BUTTON_X);
        int LOWER_BUTTON_Y = 603;
        acceptButton.setLayoutY((double)LOWER_BUTTON_Y);
        acceptButton.setOnAction(mouseEvent -> {
            IShip ship = (IShip)this.city.getActiveShip();
            if (ship != null) {
                ship.addPassenger((IPerson)this.traveler);
                this.eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, this.traveler.getDestination(), (IPlayer)this.city.getPlayer(), this.traveler.getPremium());
                this.clientEventBus.post((Object)new DisplayMessage("ch.sahits.game.graphic.display.dialog.TavernBaseSideRoomPersonDialog.acceptMessage", new Object[]{ship.getName()}));
                this.executeOnCloseButtonClicked();
                this.traveler.leave();
            }
        });
        BooleanBinding disable = this.disableAcceptBinding();
        acceptButton.setDisable(disable.get());
        disable.addListener((observableValue, oldValue, newValue) -> acceptButton.setDisable(newValue.booleanValue()));
        this.getContent().addAll((Object[])new Node[]{dt, acceptButton});
    }

    private BooleanBinding disableAcceptBinding() {
        return new BooleanBinding(){
            {
                for (IShip ship : TavernTravelerDialog.this.city.getPlayersShips()) {
                    super.bind(new Observable[]{ship.passengerPresentProperty()});
                }
            }

            protected boolean computeValue() {
                if (TavernTravelerDialog.this.city.getActiveShip() != null && TavernTravelerDialog.this.city.getActiveShip() instanceof IShip) {
                    return !((IShip)TavernTravelerDialog.this.city.getActiveShip()).getPassenger().isPresent();
                }
                return false;
            }
        };
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_TAVERN);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }

    public void close() {
        super.close();
        this.tavernUtil.stopTalkingToPerson(this.tavernState, (IPlayer)this.city.getPlayer());
    }
}

