/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.display.dialog.util;

import ch.sahits.game.javafx.control.BarrelAmount;
import ch.sahits.game.javafx.control.OpenPatricianSmallWaxButton;
import ch.sahits.game.javafx.control.PlaceHolder;
import ch.sahits.game.javafx.model.Table;
import ch.sahits.game.javafx.util.JavaFXUtils;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.ship.IShip;
import com.google.common.base.Preconditions;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.StringBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.RowConstraints;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class DialogUtil {
    @Autowired
    private JavaFXUtils fxUtils;

    public BooleanBinding enableShipCatalogueForShips(final ICityPlayerProxyJFX city) {
        return new BooleanBinding(){
            {
                super.bind(new Observable[]{city.getPlayersShips()});
            }

            protected boolean computeValue() {
                return city.getPlayersShips().size() > 1;
            }
        };
    }

    public EventHandler<MouseEvent> createNextActionForShips(final ICityPlayerProxyJFX city, final ObjectProperty<IShip> currentShip) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ObservableList ships = city.getPlayersShips();
                if (ships.size() > 1) {
                    if (((IShip)ships.get(ships.size() - 1)).equals(currentShip.get())) {
                        currentShip.set(ships.get(0));
                    } else {
                        for (int i = 0; i < ships.size() - 1; ++i) {
                            if (!((IShip)ships.get(i)).equals(currentShip.get())) continue;
                            IShip nextShip = (IShip)ships.get(i + 1);
                            currentShip.set((Object)nextShip);
                            break;
                        }
                    }
                }
            }
        };
    }

    public EventHandler<MouseEvent> createPreviousActionForShips(final ICityPlayerProxyJFX city, final ObjectProperty<IShip> currentShip) {
        return new EventHandler<MouseEvent>(){

            public void handle(MouseEvent mouseEvent) {
                ObservableList ships = city.getPlayersShips();
                if (ships.size() > 1) {
                    if (((IShip)ships.get(0)).equals(currentShip.get())) {
                        currentShip.set(ships.get(ships.size() - 1));
                    } else {
                        for (int i = 1; i < ships.size(); ++i) {
                            if (!((IShip)ships.get(i)).equals(currentShip.get())) continue;
                            IShip prevShip = (IShip)ships.get(i - 1);
                            currentShip.set((Object)prevShip);
                            break;
                        }
                    }
                }
            }
        };
    }

    public GridPane createGridPaneFromModel(Table model) {
        return this.fxUtils.createGridPaneFromModel(model);
    }

    public GridPane createShipSelection3LinesForShips(ICityPlayerProxyJFX city, final ObjectProperty<IShip> currentShip) {
        GridPane shipSelectionPane = new GridPane();
        RowConstraints rowConstraint = new RowConstraints(24.0);
        shipSelectionPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraint, rowConstraint, rowConstraint});
        ColumnConstraints colConstraint = new ColumnConstraints(64.0);
        shipSelectionPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{colConstraint, colConstraint, colConstraint, colConstraint, colConstraint});
        Text shipName = new Text();
        StringBinding shipNameBinding = new StringBinding(){
            {
                super.bind(new Observable[]{currentShip});
            }

            protected String computeValue() {
                IShip ship = (IShip)currentShip.get();
                return ship.getShipType().name() + " " + ship.getName();
            }
        };
        shipName.getStyleClass().add((Object)"dialogText");
        shipName.textProperty().bind((ObservableValue)shipNameBinding);
        shipSelectionPane.add((Node)shipName, 1, 0, 3, 1);
        GridPane.setHalignment((Node)shipName, (HPos)HPos.CENTER);
        BooleanBinding enablePrevNext = this.enableShipCatalogueForShips(city);
        final OpenPatricianSmallWaxButton prevShip = new OpenPatricianSmallWaxButton("<");
        prevShip.getStyleClass().add((Object)"actionButton");
        prevShip.setOnAction(this.createPreviousActionForShips(city, currentShip));
        prevShip.setDisable(!enablePrevNext.get());
        shipSelectionPane.add((Node)prevShip, 0, 1);
        final OpenPatricianSmallWaxButton nextShip = new OpenPatricianSmallWaxButton(">");
        nextShip.getStyleClass().add((Object)"actionButton");
        nextShip.setOnAction(this.createNextActionForShips(city, currentShip));
        nextShip.setDisable(!enablePrevNext.get());
        shipSelectionPane.add((Node)nextShip, 4, 1);
        enablePrevNext.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean oldValue, Boolean newValue) {
                nextShip.setDisable(newValue == false);
                prevShip.setDisable(newValue == false);
            }
        });
        BarrelAmount shipSize = new BarrelAmount();
        StringBinding shipSizeBinding = new StringBinding(){
            {
                super.bind(new Observable[]{currentShip});
            }

            protected String computeValue() {
                return String.valueOf(((IShip)currentShip.get()).getSize());
            }
        };
        shipSize.amountProperty().bind((ObservableValue)shipSizeBinding);
        shipSelectionPane.add((Node)shipSize, 1, 2);
        GridPane.setHalignment((Node)shipSize, (HPos)HPos.CENTER);
        Text damage = new Text();
        damage.getStyleClass().add((Object)"dialogText");
        StringBinding damageBinding = new StringBinding(){
            {
                super.bind(new Observable[]{currentShip});
            }

            protected String computeValue() {
                return String.valueOf(100 - ((IShip)currentShip.get()).getDamage());
            }
        };
        damage.textProperty().bind((ObservableValue)damageBinding);
        shipSelectionPane.add((Node)damage, 2, 2);
        GridPane.setHalignment((Node)damage, (HPos)HPos.CENTER);
        Text sailorsOnShip2 = new Text();
        sailorsOnShip2.getStyleClass().add((Object)"dialogText");
        final SailorOnShipBinding sailorsOnShipBinding = new SailorOnShipBinding(currentShip);
        currentShip.addListener((ChangeListener)new ChangeListener<IShip>(){

            public void changed(ObservableValue<? extends IShip> observableValue, IShip oldValue, IShip newValue) {
                sailorsOnShipBinding.delegateUnbind(new Observable[]{oldValue.numberOfSailorsProperty()});
                sailorsOnShipBinding.delegateBind(new Observable[]{newValue.numberOfSailorsProperty()});
            }
        });
        sailorsOnShip2.textProperty().bind((ObservableValue)sailorsOnShipBinding);
        shipSelectionPane.add((Node)sailorsOnShip2, 3, 2);
        GridPane.setHalignment((Node)sailorsOnShip2, (HPos)HPos.CENTER);
        return shipSelectionPane;
    }

    public Pane center(Control childNode) {
        int width = 434;
        Pane g = new Pane(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = (434.0 - childNode.getWidth()) / 2.0;
            g.setLayoutX(inset);
        });
        return g;
    }

    public Pane center(ImageView childNode) {
        int width = 434;
        Pane g = new Pane(new Node[]{childNode});
        double in = (434.0 - childNode.getImage().getWidth()) / 2.0;
        g.setLayoutX(in);
        childNode.getImage().widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = (434.0 - childNode.getImage().getWidth()) / 2.0;
            g.setLayoutX(inset);
        });
        return g;
    }

    public Group center(Pane childNode) {
        int width = 434;
        Group g = new Group(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = (434.0 - childNode.getWidth()) / 2.0;
            g.setLayoutX(inset);
        });
        if (childNode instanceof FlowPane) {
            ((FlowPane)childNode).setAlignment(Pos.CENTER);
        }
        return g;
    }

    public Group right(Pane childNode) {
        int width = 434;
        Group g = new Group(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = 434.0 - childNode.getWidth();
            g.setLayoutX(inset);
        });
        if (childNode instanceof FlowPane) {
            ((FlowPane)childNode).setAlignment(Pos.CENTER_RIGHT);
        }
        return g;
    }

    public Pane right(Control childNode) {
        int width = 434;
        Pane g = new Pane(new Node[]{childNode});
        childNode.widthProperty().addListener((observable, oldValue, newValue) -> {
            double inset = 434.0 - childNode.getWidth();
            g.setLayoutX(inset);
        });
        return g;
    }

    public Node createVerticalSpacer(int heigth) {
        return new PlaceHolder(1.0, (double)heigth);
    }

    public int removeById(Pane parent, String id) {
        Preconditions.checkNotNull((Object)id, (Object)"The identifying id must not be null");
        ObservableList children = parent.getChildren();
        int index = -1;
        for (int i = 0; i < children.size(); ++i) {
            Node node = (Node)children.get(i);
            if (!id.equals(node.getId())) continue;
            index = i;
            break;
        }
        if (index >= 0) {
            children.remove(index);
        }
        return index;
    }

    private class SailorOnShipBinding
    extends StringBinding {
        private final ObjectProperty<IShip> currentShip;

        SailorOnShipBinding(ObjectProperty<IShip> currentShip) {
            super.bind(new Observable[]{currentShip, ((IShip)currentShip.get()).numberOfSailorsProperty()});
            this.currentShip = currentShip;
        }

        protected String computeValue() {
            IShip ship = (IShip)this.currentShip.get();
            StringBuilder sb = new StringBuilder();
            sb.append(ship.getNumberOfSailors()).append(" (").append(ship.getMinNumberOfSailors()).append(" - ").append(ship.getMaxNumberOfSailors()).append(")");
            return sb.toString();
        }

        public void delegateUnbind(Observable ... values) {
            this.unbind(values);
        }

        public void delegateBind(Observable ... values) {
            this.bind(values);
        }
    }
}

