/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.graphic.service;

import ch.sahits.game.graphic.image.IMapImageServiceFacade;
import ch.sahits.game.javafx.model.BezierCurveControls;
import ch.sahits.game.javafx.model.BezierPath;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.model.PathInterpolatorMap;
import ch.sahits.game.openpatrician.clientserverinterface.model.VesselPositionUpdateData;
import ch.sahits.game.openpatrician.clientserverinterface.service.MapService;
import ch.sahits.game.openpatrician.clientserverinterface.service.PathInterpolator;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.sea.TravellingVessels;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javafx.geometry.Point2D;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class BezierPathConverter
implements IPathConverter {
    private final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    private IMapImageServiceFacade mapImageService;
    @Autowired
    private TravellingVessels vessels;
    @Autowired
    private PathInterpolatorMap interpolators;
    @Autowired
    private Date date;
    @Autowired
    private MapService mapService;

    public Optional<Path> createPath(INavigableVessel vessel, List<Point2D> pointedPath, double scale) {
        List<Point2D> reducedList = this.reduceLinePoints(pointedPath);
        List<Point2D> controlPoints = this.interpolate(this.applyScale(reducedList, scale), 0.5f);
        BezierPath pathModel = this.convertToPathModel(controlPoints);
        Path path = null;
        if (vessel.getOwner() instanceof IHumanPlayer) {
            path = new Path();
            path.setStroke((Paint)Color.RED);
            path.setStrokeWidth(2.0);
            if (!pathModel.getBezierCurves().isEmpty()) {
                Point2D p = pathModel.getStartpoint();
                MoveTo moveTo = new MoveTo();
                moveTo.setX(p.getX());
                moveTo.setY(p.getY());
                path.getElements().add((Object)moveTo);
                for (BezierCurveControls segment : pathModel.getBezierCurves()) {
                    CubicCurveTo cubicTo = new CubicCurveTo();
                    cubicTo.setControlX1(segment.getControlPoint1().getX());
                    cubicTo.setControlY1(segment.getControlPoint1().getY());
                    cubicTo.setControlX2(segment.getControlPoint2().getX());
                    cubicTo.setControlY2(segment.getControlPoint2().getY());
                    cubicTo.setX(segment.getPoint().getX());
                    cubicTo.setY(segment.getPoint().getY());
                    path.getElements().add((Object)cubicTo);
                }
            }
        }
        this.logger.trace("Add travelling vessel {} of {} {}", new Object[]{vessel.getName(), vessel.getOwner().getName(), vessel.getOwner().getLastName()});
        Optional<Path> optPath = Optional.ofNullable(path);
        this.vessels.addVessel(vessel, optPath, reducedList);
        PathInterpolator pathInterpolator = new PathInterpolator(reducedList);
        long duration = this.calculateDuration(vessel, pathInterpolator, 1.0);
        long nbTicks = duration / 100L;
        double fractionPerTick = 1.0 / (double)nbTicks;
        pathInterpolator.setTravelFractionPerTick(fractionPerTick);
        VesselPositionUpdateData data = new VesselPositionUpdateData(pathInterpolator, pointedPath.get(0), pointedPath.get(pointedPath.size() - 1), duration);
        data.setAnimationStartMS(System.currentTimeMillis());
        this.interpolators.put(vessel, data);
        this.logger.trace("Add path interpolator from {} to {}, nb interpolators={}, update fraction per tick={}", new Object[]{reducedList.get(0), reducedList.get(reducedList.size() - 1), this.interpolators.size(), fractionPerTick});
        return optPath;
    }

    public long calculateDuration(INavigableVessel vessel, PathInterpolator interpolator, double fraction) {
        double speedKmPerH = vessel.getCurrentSpeed();
        double distanceInPixels = interpolator.getTotalLength() * fraction;
        double distanceInKm = this.mapService.convertToDistenceInKm(distanceInPixels);
        double tickUpdateInHours = (double)this.date.getTickUpdate() / 60.0;
        double inGameAnimationDurationInHours = distanceInKm / speedKmPerH;
        long nbTicks = Math.round(Math.ceil(inGameAnimationDurationInHours / tickUpdateInHours));
        this.logger.debug("Distance of {}km can be traveled in {}h at {}km/h, which results in {} clock ticks or {}ms, fraction to travel={}", new Object[]{distanceInKm, inGameAnimationDurationInHours, speedKmPerH, nbTicks, 100L * nbTicks, fraction});
        return 100L * nbTicks;
    }

    private List<Point2D> applyScale(List<Point2D> pointedPath, double scale) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        for (Point2D p : pointedPath) {
            list.add(new Point2D(p.getX() * scale, p.getY() * scale));
        }
        return list;
    }

    List<Point2D> interpolate(List<Point2D> segmentPoints, float scale) {
        ArrayList<Point2D> controlPoints = new ArrayList<Point2D>();
        if (segmentPoints.size() < 2) {
            return controlPoints;
        }
        for (int i = 0; i < segmentPoints.size(); ++i) {
            Point2D p1;
            Point2D p0;
            Point2D tangent;
            if (i == 0) {
                Point2D p12 = segmentPoints.get(i);
                Point2D p2 = segmentPoints.get(i + 1);
                tangent = p2.subtract(p12);
                Point2D q1 = p12.add(tangent.multiply((double)scale));
                controlPoints.add(p12);
                controlPoints.add(q1);
                continue;
            }
            if (i == segmentPoints.size() - 1) {
                p0 = segmentPoints.get(i - 1);
                p1 = segmentPoints.get(i);
                tangent = p1.subtract(p0);
                Point2D q0 = p1.subtract(tangent.multiply((double)scale));
                controlPoints.add(q0);
                controlPoints.add(p1);
                continue;
            }
            p0 = segmentPoints.get(i - 1);
            p1 = segmentPoints.get(i);
            Point2D p2 = segmentPoints.get(i + 1);
            Point2D tangent2 = p2.subtract(p0).normalize();
            Point2D q0 = p1.subtract(tangent2.multiply((double)scale * p1.subtract(p0).magnitude()));
            Point2D q1 = p1.add(tangent2.multiply((double)scale * p2.subtract(p1).magnitude()));
            controlPoints.add(q0);
            controlPoints.add(p1);
            controlPoints.add(q1);
        }
        return controlPoints;
    }

    private BezierPath convertToPathModel(List<Point2D> points) {
        BezierPath bezierPath = new BezierPath(points.get(0));
        int i = 1;
        while (i < points.size()) {
            Point2D outgoingControl = points.get(i++);
            Point2D incomingControl = points.get(i++);
            Point2D segmentEndPoint = points.get(i++);
            BezierCurveControls segment = new BezierCurveControls(segmentEndPoint, outgoingControl, incomingControl);
            bezierPath.addSegment(segment);
        }
        return bezierPath;
    }

    public List<Point2D> reduceLinePoints(List<Point2D> initialPoints) {
        HashMap<Point2D, Distances> distance = new HashMap<Point2D, Distances>();
        for (int i = 0; i < initialPoints.size() - 1; ++i) {
            Point2D currentPoint = initialPoints.get(i);
            Point2D nextPoint = initialPoints.get(i + 1);
            Point2D v1 = nextPoint.subtract(currentPoint);
            double max = currentPoint.distance(nextPoint);
            for (int j = i + 1; j < initialPoints.size(); ++j) {
                Point2D next = initialPoints.get(j);
                Point2D v2 = next.subtract(currentPoint);
                if (!(v1.angle(v2) < 1.0)) continue;
                max = currentPoint.distance(next);
            }
            double shoreDistance = 5.0;
            try {
                shoreDistance = this.mapImageService.distanceToShore(currentPoint, max);
            }
            catch (IOException e) {
                this.logger.warn("Failed to calculate the distance to the shore", (Throwable)e);
            }
            Distances value = new Distances(shoreDistance, max);
            distance.put(currentPoint, value);
        }
        distance.put(initialPoints.get(initialPoints.size() - 1), new Distances(Double.MAX_VALUE, Double.MAX_VALUE));
        LinkedList<Point2D> reducedList = new LinkedList<Point2D>();
        for (int i = 0; i < initialPoints.size(); ++i) {
            boolean isCorner;
            Point2D currentPoint = initialPoints.get(i);
            if (i == 0 || i == initialPoints.size() - 1) {
                isCorner = true;
            } else {
                Point2D v2;
                Point2D before = initialPoints.get(i - 1);
                Point2D next = initialPoints.get(i + 1);
                Point2D v1 = currentPoint.subtract(before);
                boolean bl = isCorner = v1.angle(v2 = next.subtract(currentPoint)) >= 1.0;
            }
            if (isCorner) {
                reducedList.add(currentPoint);
                continue;
            }
            Distances dist = (Distances)distance.get(currentPoint);
            double distanceToLastPoint = reducedList.getLast().distance(currentPoint);
            if (!(distanceToLastPoint >= dist.distanceToShore) || !(dist.distanceToShore < dist.distanceToCornor)) continue;
            reducedList.add(currentPoint);
        }
        return reducedList;
    }

    private static class Distances {
        private final double distanceToShore;
        private final double distanceToCornor;

        public Distances(double distanceToShore, double distanceToCornor) {
            this.distanceToShore = distanceToShore;
            this.distanceToCornor = distanceToCornor;
        }
    }
}

