/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.javafx.control;

import ch.sahits.game.event.NoticeBoardClose;
import ch.sahits.game.event.data.SwitchCity;
import ch.sahits.game.graphic.display.ClientViewState;
import ch.sahits.game.graphic.display.EViewState;
import ch.sahits.game.graphic.display.dialog.util.DialogFactory;
import ch.sahits.game.graphic.javafx.display.IDialogContoller;
import ch.sahits.game.javafx.model.EDialogType;
import ch.sahits.game.openpatrician.annotation.ClassCategory;
import ch.sahits.game.openpatrician.annotation.EClassCategory;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@ClassCategory(value={EClassCategory.SINGLETON_BEAN})
public class ViewStatus
extends Group {
    private final Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    private StringProperty city;
    private DoubleProperty width;
    private Text cityName;
    @Autowired
    private ClientViewState clientViewState;
    @Autowired
    private DialogFactory dialogFactory;
    @Autowired
    @Qualifier(value="clientEventBus")
    protected AsyncEventBus clientEventBus;
    private IDialogContoller dialogContoller;

    public ViewStatus() {
        this.setManaged(false);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource(((Object)((Object)this)).getClass().getSimpleName() + ".css").toExternalForm());
        this.city = new SimpleStringProperty((Object)this, "city", "");
        this.width = new SimpleDoubleProperty((Object)this, "controlWidth", 0.0);
        this.cityName = new Text();
        this.cityName.setFill((Paint)Color.WHITE);
        this.cityName.getStyleClass().add((Object)"cityName");
        this.cityName.textProperty().bind((ObservableValue)this.city);
        this.cityName.setOnMouseReleased(this.createHistoryDisplayHandler());
        Rectangle placeholder = new Rectangle(this.width.doubleValue(), 50.0);
        placeholder.setFill((Paint)Color.TRANSPARENT);
        placeholder.widthProperty().bind((ObservableValue)this.width);
        StackPane centering = new StackPane();
        centering.prefWidthProperty().bind((ObservableValue)this.width);
        centering.getChildren().add((Object)this.cityName);
        this.getChildren().addAll((Object[])new Node[]{placeholder, centering});
    }

    @PostConstruct
    private void init() {
        this.clientViewState.stateProperty().addListener((observable, oldValue, newValue) -> {
            if (this.clientViewState.getState() != EViewState.MAP) {
                this.cityName.textProperty().bind((ObservableValue)this.city);
            } else {
                this.cityName.textProperty().unbind();
                this.cityName.setText("");
            }
        });
        this.clientEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientEventBus.unregister((Object)this);
    }

    public void setDialogContoller(IDialogContoller dialogContoller) {
        this.dialogContoller = dialogContoller;
    }

    private EventHandler<? super MouseEvent> createHistoryDisplayHandler() {
        return mouseEvent -> {
            if (this.clientViewState.getCurrentCityProxy().isPresent()) {
                this.clientEventBus.post((Object)new NoticeBoardClose());
                this.dialogContoller.replaceDialog(EDialogType.CITY_HISTORY, new Object[0]);
            }
        };
    }

    private String getHistoryResourceName(String name) {
        return "history." + name;
    }

    public void setCity(String city) {
        this.city.set((Object)city);
    }

    public String getCity() {
        return (String)this.city.get();
    }

    public StringProperty cityProperty() {
        return this.city;
    }

    public DoubleProperty widthProperty() {
        return this.width;
    }

    public void setWidth(double width) {
        this.width.set(width);
    }

    public double getWidth() {
        return this.width.doubleValue();
    }

    public void setFont(Font f) {
        this.cityName.setFont(f);
    }

    @Subscribe
    public void handleSwitchToCity(SwitchCity event) {
        this.setCity(event.getToCity().getName());
    }
}

