/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.loaner;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.LoanerService;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.IViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.model.ICitizen;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.city.ILoaner;
import ch.sahits.game.openpatrician.model.city.impl.IDebt;
import ch.sahits.game.openpatrician.model.city.impl.LoanerState;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.time.LocalDateTime;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LoanerListLoansDialog
extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations translator;
    @Autowired
    private ClientViewState viewState;
    private LoanerState loaner;
    private final ICityPlayerProxyJFX city;
    @Autowired
    private LoanerService loanerService;

    public LoanerListLoansDialog(ICityPlayerProxyJFX city) {
        super(false);
        this.city = city;
    }

    @PostConstruct
    private void initializeDialog() {
        ICity city1 = this.city.getCity();
        this.loaner = (LoanerState)this.loanerService.findLoaner(city1);
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.LoanerListLoansDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerListLoansDialog.subHeader", "introText", new Object[0]);
        this.addVerticalSpacer(20);
        String cityName = city1.getName();
        for (IDebt debt : this.loanerService.findLoans((ILoaner)this.loaner, (IPlayer)this.city.getPlayer())) {
            ICitizen debitor = debt.getDebitor();
            String title = this.translator.getLocalDisplayName(debitor.getRank());
            int paybacksum = (int)(debt.getInterest() * (double)debt.getAmount());
            LocalDateTime dueDate1 = debt.getDueDate();
            String dueDate = this.translator.toDisplayString(dueDate1);
            this.addDecoratedText("ch.sahits.game.openpatrician.display.dialog.LoanerListLoansDialog.outstandingLoan", "outstandingLoan", title, debitor.getName(), debitor.getLastName(), cityName, paybacksum, dueDate);
        }
    }

    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(this.viewState.getCurrentCityProxy().get(), (IViewChangeEvent)EViewChangeEvent.NOTICE_LOANER);
        this.clientEventBus.post((Object)new NoticeBoardUpdate((ICityPlayerProxyJFX)proxy));
        super.executeOnCloseButtonClicked();
    }
}

