/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.dialog.tavern.TavernBaseSideRoomPersonDialog;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.ISideRoomPerson;
import ch.sahits.game.openpatrician.model.people.ISmuggler;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernSmugglerDialog
extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Random rnd;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientTaskFactory taskFactory;

    public TavernSmugglerDialog(ICityPlayerProxyJFX city) {
        super(city, (ISideRoomPerson)city.getCity().getCityState().getTavernState().getSmuggler());
    }

    @PostConstruct
    private void initializeDialog() {
        this.setTitle(this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernSmugglerDialog.title", new Object[0], this.locale.getCurrentLocal()));
        this.initializeButtons();
        ISmuggler smuggler = (ISmuggler)this.currentPerson.get();
        String loadedText = this.messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernSmugglerDialog.dialog", new Object[0], this.locale.getCurrentLocal());
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("amount", smuggler.getAmount());
        DecoratedText dt = this.decoratedTextFactory.createDecoratedText(loadedText, parameters);
        this.getContent().addAll((Object[])new Node[]{dt});
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                int probability;
                ArrayList ships = Lists.newArrayList((Iterable)this.city.getPlayersShips());
                Collections.shuffle(ships);
                ISmuggler smuggler = (ISmuggler)this.currentPerson.get();
                boolean shipFound = false;
                for (IShip ship : ships) {
                    if (ship.getCapacity() <= smuggler.getAmount()) continue;
                    ship.setOccupiedSpace(smuggler.getAmount());
                    shipFound = true;
                    break;
                }
                if (!shipFound) {
                    LocalDateTime deadline = this.date.getCurrentDate().plusDays(10L);
                    this.eventHandlerFactory.getShipArrivalForLoadingHandler(this.city.getCity(), (IPlayer)this.city.getPlayer(), deadline, smuggler.getAmount(), smuggler.getPremium());
                }
                if ((probability = this.rnd.nextInt(3)) < 1) {
                    this.timedTaskListener.add((TimedTask)this.taskFactory.getDelayedCaughtAction((IPlayer)this.city.getPlayer(), this.city.getCity()));
                }
                this.city.getPlayer().updateCrimialDrive(1);
                smuggler.leave();
                this.executeOnCloseButtonClicked();
            }
            catch (RuntimeException e) {
                this.logger.error("Failed to accept smugglar offer", (Throwable)e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding(){

            protected boolean computeValue() {
                ISmuggler smuggler = (ISmuggler)TavernSmugglerDialog.this.currentPerson.get();
                return TavernSmugglerDialog.this.tavernDialogUtil.noShipWithEnoughCapacityAvailable(TavernSmugglerDialog.this.city, smuggler.getAmount() / 10);
            }
        };
    }
}

