/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.javafx.action;

import ch.sahits.game.openpatrician.clientserverinterface.service.TradeService;
import ch.sahits.game.openpatrician.display.dialog.service.ITransferableJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.product.AmountablePrice;
import ch.sahits.game.openpatrician.model.product.IWare;
import ch.sahits.game.openpatrician.model.ship.INavigableVessel;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;

@Prototype
@ClassCategory(value={EClassCategory.HANDLER, EClassCategory.PROTOTYPE_BEAN})
public class Storage2ShipJFXAction
implements Runnable {
    private final IWare ware;
    private final ITransferableJFX transfer;
    @Autowired
    private TradeService tradeService;

    public Storage2ShipJFXAction(IWare ware, ITransferableJFX transfer) {
        this.ware = ware;
        this.transfer = transfer;
    }

    @Override
    public void run() {
        INavigableVessel ship = this.transfer.getVessel();
        IPlayer player = this.transfer.getPlayer();
        Optional optOffice = player.findTradingOffice(this.transfer.getCity());
        if (optOffice.isPresent() && ((ITradingOffice)optOffice.get()).getWare(this.ware).getAmount() > 0) {
            ITradingOffice office = (ITradingOffice)optOffice.get();
            AmountablePrice amountable = office.getWare(this.ware);
            int availableAmountStorage = amountable.getAmount();
            int amount2Move = this.transfer.getAmount(availableAmountStorage);
            this.tradeService.transferFromStorageToVessel(office, ship, player, this.ware, amount2Move);
        }
    }
}

