/*
 * Decompiled with CFR 0.152.
 */
package ch.sahits.game.openpatrician.display.scene;

import ch.sahits.game.graphic.image.IImageLoader;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.javafx.control.GameStatus;
import ch.sahits.game.openpatrician.display.javafx.control.MainMenu;
import ch.sahits.game.openpatrician.display.javafx.control.MiniMap;
import ch.sahits.game.openpatrician.display.javafx.control.SubMenu;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.display.scene.MainGameSceneBackground;
import ch.sahits.game.openpatrician.display.service.IJavaFXControlLoader;
import ch.sahits.game.openpatrician.event.data.NewGameClient;
import ch.sahits.game.openpatrician.javafx.OpenPatricianScene;
import ch.sahits.game.openpatrician.javafx.control.NoticeBoard;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

@Prototype
@ClassCategory(value={EClassCategory.PROTOTYPE_BEAN})
public class MainGameScene
extends OpenPatricianScene {
    private static final int MAP_OVERVIEW_HEIGHT = 207;
    private static final int LEFT_STATUS_PANEL_WIDTH = 250;
    static final int TOP_STATUS_HEIGHT = 70;
    private static final int BORDER_SPACING = 10;
    private static final int HORIZONTAL_DECO_HEIGHT = 20;
    static final int MENU_HEIGHT = 71;
    static final int NOTICE_HEIGHT = 250;
    static final int LEFT_PANEL_WIDTH = 310;
    static final int MINMIMAL_DISPLAY_HEIGHT = 666;
    private MainGameSceneBackground background;
    private GameStatus gameStatus;
    private ViewStatus viewStatus;
    private MainGameView mainGameView;
    @Autowired
    @Qualifier(value="serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    private IJavaFXControlLoader controlLoader;
    private Group foreground;
    private final MiniMap miniMap;

    public MainGameScene(double width, double height, IImageLoader loader, IJavaFXControlLoader controlLoader) {
        super((Region)new StackPane());
        this.controlLoader = controlLoader;
        this.background = new MainGameSceneBackground(width, height, loader);
        this.foreground = new Group();
        this.foreground.setManaged(false);
        this.gameStatus = controlLoader.getGameStatus();
        this.gameStatus.setLayoutY(20.0);
        this.gameStatus.setFont(controlLoader.getFontLoader().createDefaultFont(18));
        this.viewStatus = controlLoader.getViewStatus();
        this.viewStatus.setWidth(width - 320.0);
        this.viewStatus.setLayoutX(310.0);
        this.viewStatus.setLayoutY(30.0);
        this.miniMap = controlLoader.getMiniMap();
        this.miniMap.setLayoutX(5.0);
        this.miniMap.setLayoutY(78.0);
        MainMenu mainMenu = controlLoader.getMainMenu();
        mainMenu.setLayoutX(15.0);
        mainMenu.setLayoutY(287.0);
        SubMenu subMenu = controlLoader.getSubMenu();
        subMenu.setLayoutX(10.0);
        subMenu.setLayoutY(368.0);
        NoticeBoard noticeBoard = controlLoader.getNoticeBoard();
        noticeBoard.setLayoutX(5.0);
        noticeBoard.setLayoutY(424.0);
        this.foreground.getChildren().addAll((Object[])new Node[]{this.gameStatus, this.viewStatus, this.miniMap, mainMenu, subMenu, noticeBoard});
        StackPane root = (StackPane)this.getRoot();
        root.getChildren().addAll((Object[])new Node[]{this.background, this.foreground});
    }

    @PostConstruct
    private void initializeEventSystem() {
        this.clientServerEventBus.register((Object)this);
    }

    @PreDestroy
    private void unregister() {
        this.clientServerEventBus.unregister((Object)this);
    }

    @Subscribe
    public void initializeGameView(NewGameClient newGameDTO) {
        double width = this.calculateMainGameViewWidth(this.background.getSceneWidth());
        double height = this.calculateMainGameViewHeight(this.background.getSceneHeight());
        this.mainGameView = this.controlLoader.getMainGameView(width, height);
        this.mainGameView.setLayoutX(310.0);
        this.mainGameView.setLayoutY(70.0);
        Platform.runLater(() -> {
            if (this.foreground.getChildren().contains((Object)this.mainGameView)) {
                this.foreground.getChildren().remove((Object)this.mainGameView);
            }
            this.foreground.getChildren().add((Object)this.mainGameView);
        });
        this.miniMap.setDialogContoller(this.mainGameView);
    }

    private double calculateMainGameViewHeight(double height) {
        return height - 10.0 - 71.0 + 1.0;
    }

    private double calculateMainGameViewWidth(double width) {
        return width - 310.0 - 10.0;
    }

    public void widthChange(double oldWidth, double newWidth) {
        this.background.widthChange(oldWidth, newWidth);
        this.viewStatus.setWidth(newWidth - 320.0);
        if (this.mainGameView != null) {
            this.mainGameView.widthChange(this.calculateMainGameViewWidth(oldWidth), this.calculateMainGameViewWidth(newWidth));
        }
    }

    public void heightChange(double oldHeight, double newHeigth) {
        this.background.heightChange(oldHeight, newHeigth);
        if (this.mainGameView != null) {
            this.mainGameView.heightChange(this.calculateMainGameViewHeight(oldHeight), this.calculateMainGameViewHeight(newHeigth));
        }
    }
}

