package ch.sahits.game.openpatrician.display;

import ch.sahits.game.openpatrician.display.event.handler.IOpenPatricianDisplayEventHandlerComponents;
import ch.sahits.game.openpatrician.event.handler.IOpenPatricianGameEventHandlerComponents;
import ch.sahits.game.openpatrician.display.notice.OpenPatricianNoticeBoard;
import ch.sahits.game.openpatrician.display.javafx.MainGameView;
import ch.sahits.game.openpatrician.display.service.BezierPathConverter;
import ch.sahits.game.openpatrician.display.javafx.control.GameStatus;
import ch.sahits.game.openpatrician.display.javafx.control.MainMenu;
import ch.sahits.game.openpatrician.display.javafx.control.MiniMap;
import ch.sahits.game.openpatrician.display.javafx.control.SubMenu;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.clientserverinterface.ClientServerInterfaceStandaloneConfiguration;
import ch.sahits.game.openpatrician.engine.sea.IPathConverter;
import ch.sahits.game.openpatrician.clientserverinterface.event.IEventPropagator;
import ch.sahits.game.openpatrician.server.ServerConfiguration;
import ch.sahits.game.openpatrician.server.events.StandaloneMessagePropagator;
import ch.sahits.game.openpatrician.utilities.spring.DialogScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;

/**
 * This is the default Spring configuration
 * that is used when the application is neither
 * started in server nor client mode.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Nov 29, 2014
 */
@Configuration
@Import({ClientServerInterfaceStandaloneConfiguration.class, ServerConfiguration.class, UICommonConfiguration.class})
@ComponentScan(basePackageClasses = {IOpenPatricianDisplayEventHandlerComponents.class, IOpenPatricianGameEventHandlerComponents.class})
@ClassCategory(EClassCategory.STARTUP)
public class StandaloneConfiguration {

    @Bean
    public static DialogScope dialogScope() {
        return new DialogScope();
    }

    @Bean
    @Lazy
    public MiniMap miniMap() {
        return new MiniMap();
    }
    @Bean
    @Lazy
    public MainMenu mainMenu() {
        return new MainMenu();
    }
    @Bean
    @Lazy
    public SubMenu subMenu() {
        return new SubMenu();
    }
    @Bean
    @Lazy
    public OpenPatricianNoticeBoard noticeBoard() {
        OpenPatricianNoticeBoard bean = new OpenPatricianNoticeBoard();
        return bean;
    }
    @Bean
    @Lazy
    public ViewStatus viewStatus() {
        return new ViewStatus();
    }
    @Bean
    @Lazy
    public GameStatus gameStatus() {
        return new GameStatus();
    }
    @Bean
    @Scope("prototype")
    public MainGameView mainGameView(double width, double height) {
        return new MainGameView(width, height);
    }

    @Bean
    public IEventPropagator standaloneMessagePropagator() {
         return new StandaloneMessagePropagator();
    }

    @Bean
    @Lazy
    public IPathConverter pathConverter() {
        return  new BezierPathConverter();
    }
    @Bean
    @Lazy
    public CheatKeyEventListener cheatModeKeyListener() {
        return new CheatKeyEventListener();
    }

}
