package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import javafx.scene.Node;
import javafx.scene.Parent;

/**
 * Utility class to retrieve the parent of a node. This class provides an abstraction for better testing.
 * @author Andi Hotz, (c) Sahits GmbH, 2015
 *         Created on Oct 23, 2015
 */
@ClassCategory(EClassCategory.SINGLETON_BEAN)
@LazySingleton
public class ParentNodeProvider {
    /**
     * Return the parent of the node.
     * @param node
     * @return
     */
    public Parent getParent(Node node) {
        return node.getParent();
    }
}
