package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.control.CoinPriceAlwaysVisible;
import ch.sahits.game.openpatrician.javafx.model.ControlTableCell;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.IBalanceSheet;
import ch.sahits.game.openpatrician.model.building.IBuilding;
import ch.sahits.game.openpatrician.model.building.ITownHouse;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWorkShop;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.base.Preconditions;
import com.google.common.eventbus.AsyncEventBus;
import javafx.beans.binding.StringBinding;
import javafx.geometry.HPos;
import javafx.scene.Group;
import javafx.scene.text.Text;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.List;
import java.util.Optional;

/**
 * Dialog for the balance.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 6, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TradeOfficeBalanceDialog extends TabelViewDialog {
	/** Reference to the city view model */
	protected final ICityPlayerProxyJFX city;
	@Autowired
	private Date date;
    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
	@Autowired
	private Locale locale;

	@Autowired
	private MessageSource messageSource;
	@Autowired
	private ModelTranslations modelTranslator;


	public TradeOfficeBalanceDialog(ICityPlayerProxyJFX city) {
		super();
		this.city = city;
	}
	private Group createSubTitle() {
		StringBinding fromTo = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				// FIXME: 5/15/16 this must go to the text.properties
				return modelTranslator.getStartOfWeek(date.getCurrentDate())+" to "+modelTranslator.getEndOfWeek(date.getCurrentDate());
			}
		};
		Text fromToText = new Text();
		fromToText.textProperty().bind(fromTo);
		fromToText.getStyleClass().add("dialogText");
		fromToText.setLayoutX(100);

		String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.forecast", new Object[]{}, locale.getCurrentLocal());

		Text forecast = new Text(template);
		forecast.getStyleClass().add("dialogText");
		forecast.setLayoutX(350);
		Group g = new Group();
		g.setManaged(false);
		
		g.getChildren().addAll(fromToText, forecast);

		return g;
	}
	@PostConstruct
	private void initializeModelAndDialog() {
		setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.title", new Object[]{}, locale.getCurrentLocal()));
		// create the header as sub title
		Group subTitle = createSubTitle();
		subTitle.setLayoutX(2*FRAME_BORDER);
		subTitle.setLayoutY(80);
		getContent().add(subTitle);
		Table model = createModel();
		setModel(model);
	}
	private Table createModel() {
		ICity cityModel = city.getCity();
		Optional<ITradingOffice> optOffice = city.getPlayer().findTradingOffice(cityModel);
		Preconditions.checkArgument(optOffice.isPresent(), "The trading office must be present");
		final ITradingOffice office = optOffice.get();
		final List<IWorkShop> workshops = city.getPlayer().findBuildings(cityModel, IWorkShop.class);
		final List<ITownHouse> townhouse = city.getPlayer().findBuildings(cityModel, ITownHouse.class);
		Table model = new Table();
		TableHeader header = new TableHeader(5);
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
		header.add(new StaticTextTableCell(""));
    	header.setAligenment(0, HPos.RIGHT);
    	header.setAligenment(1, HPos.LEFT);
    	header.setAligenment(2, HPos.LEFT);
    	header.setAligenment(3, HPos.LEFT);
    	header.setAligenment(4, HPos.LEFT);
    	model.setHeader(header);
    	model.setColumnWidth(100, 50, 100, 50, 150);
    	TableRow row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.rentalIncome", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding rentalIncomeLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
			}
		};
		CoinPriceAlwaysVisible coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(rentalIncomeLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding rentalIncomeForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getCurrentWeek().getRentalIncome());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(rentalIncomeForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.wages", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding wagesIncomeLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getWageCosts());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(wagesIncomeLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding wagesIncomeForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getRentalIncome());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(wagesIncomeForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);
		
		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.propertyTax", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding taxLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(taxLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding taxForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getPropertyTaxes());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(taxForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.officeTrading", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding tradingLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(tradingLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding tradingForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOfficeTrading());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(tradingForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.steward", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding stewardLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getStewardCost());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(stewardLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding stewardForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getStewardCost());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(stewardForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.other", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding otherLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
			}
		};
		coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(otherLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding otherForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				return String.valueOf(office.getBalanceLastWeek().getOtherCosts());
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(otherForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.sum", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	StringBinding sumLastWeek = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				IBalanceSheet bal = office.getBalanceLastWeek();
				int lastWeek =0;
				lastWeek += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
				lastWeek -= (bal.getOfficeTrading() + bal.getRentalIncome());
				return String.valueOf(lastWeek);
			}
		};
		coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(sumLastWeek);
		row.add(new ControlTableCell(coinPrice));
    	row.add(new StaticTextTableCell(""));
    	StringBinding sumForecast = new DateBoundStringProperty() {
			@Override
			protected String computeValue() {
				int forcast = 0;
				IBalanceSheet bal = office.getCurrentWeek();
				forcast += bal.getOtherCosts() + bal.getPropertyTaxes() + bal.getStewardCost() + bal.getWageCosts();
				forcast -= (bal.getOfficeTrading() + bal.getRentalIncome());
				return String.valueOf(forcast);
			}
		};
    	coinPrice = new CoinPriceAlwaysVisible();
		coinPrice.amountProperty().bind(sumForecast);
		row.add(new ControlTableCell(coinPrice));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
		model.add(row);

		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.buildings", new Object[]{}, locale.getCurrentLocal())));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(""));
		model.add(row);
		
		row = new TableRow();
		row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.workshops", new Object[]{workshops.size()}, locale.getCurrentLocal())));

		int workers = 0, maxWorkers = 0;
		for (IBuilding building : workshops) {
			workers += ((IWorkShop)building).getWorkers();
			maxWorkers += ((IWorkShop)building).getMaxWorkers();
		}
		row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.workers", new Object[]{workers, maxWorkers}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		model.add(row);

		row = new TableRow();
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.tenements", new Object[]{townhouse.size()}, locale.getCurrentLocal())));

		int tenants = 0, maxTenants =0;
		for (IBuilding building : townhouse) {
			tenants += ((ITownHouse)building).getOccupancy();
			maxTenants += ((ITownHouse)building).getCapacity();
		}
		row.add(new StaticTextTableCell(""));
    	row.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TradeOfficeBalanceDialog.tenants", new Object[]{tenants, maxTenants}, locale.getCurrentLocal())));
		row.add(new StaticTextTableCell(""));
		row.add(new StaticTextTableCell(""));
		model.add(row);
		
		return model;
	}
	@Override
	public void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}
	
	private abstract class DateBoundStringProperty extends StringBinding {
		{
			super.bind(date.getCurrentDateProperty());
		}
	}

}
