package ch.sahits.game.openpatrician.display.dialog;

import ch.sahits.game.openpatrician.event.NoticeBoardClose;
import ch.sahits.game.openpatrician.javafx.model.StaticTextTableCell;
import ch.sahits.game.openpatrician.javafx.model.Table;
import ch.sahits.game.openpatrician.javafx.model.TableHeader;
import ch.sahits.game.openpatrician.javafx.model.TableRow;
import ch.sahits.game.openpatrician.model.building.ITradingOffice;
import ch.sahits.game.openpatrician.model.building.IWeaponStorage;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.model.weapon.EWeapon;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.geometry.HPos;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;

/**
 * Inventory dialog of all the weapons in storage.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Dec 7, 2013
 *
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class WeaponInventoryDialog extends TabelViewDialog {

    @Autowired
    @Qualifier("clientEventBus")
    private AsyncEventBus clientEventBus;
	@Autowired
	private Locale locale;
	@Autowired
	private ModelTranslations translator;
	@Autowired
	private MessageSource messageSource;

	private IWeaponStorage weaponStorage;

	/** Reference to the city view model */
	protected final ICityPlayerProxyJFX city;
	
	public WeaponInventoryDialog(ICityPlayerProxyJFX city) {
		super();
		this.city = city;
	}
	@PostConstruct
	private void initializeDialog() {
		ITradingOffice office = city.getPlayer().findTradingOffice(city.getCity()).get(); // Office must be present otherwise the dialog should not be accessible.
		weaponStorage = office.getWeaponStorage();
		setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponInventoryDialog.title", new Object[]{}, locale.getCurrentLocal()));
		Table model = createModel();
		setModel(model);
	}
	private Table createModel() {
    	Table model = new Table();

    	TableHeader header = new TableHeader(2);
    	header.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.WeaponsDealerState.noticeboardTitle", new Object[]{}, locale.getCurrentLocal())));
    	header.add(new StaticTextTableCell(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.WeaponInventoryDialog.inStock", new Object[]{}, locale.getCurrentLocal())));
    	header.setAligenment(0, HPos.RIGHT);
    	header.setAligenment(1, HPos.RIGHT);
    	model.setHeader(header);
    	model.setColumnWidth(100, 200);
    	for (EWeapon weapon : EWeapon.values()) {
			TableRow row = new TableRow();
			row.add(new StaticTextTableCell(translator.getLocalDisplayName(weapon)));
			row.add(new StaticTextTableCell(String.valueOf(weaponStorage.getWeapon(weapon))));
			model.add(row);
		}
   	
		return model;
	}
	@Override
	public void executeOnCloseButtonClicked() {
        clientEventBus.post(new NoticeBoardClose());
		super.executeOnCloseButtonClicked();
	}

}
