package ch.sahits.game.openpatrician.display.dialog.events;

import ch.sahits.game.openpatrician.display.dialog.DefaultSimpleDialog;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.model.event.BuildingPermissionState;
import ch.sahits.game.openpatrician.model.IPlayer;
import javafx.geometry.Pos;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Dec 10, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN})
public class BuildingPermissionDialog extends DefaultSimpleDialog {
    @Autowired
    private ModelTranslations modelTranslations;
    private BuildingPermissionState state;

    public BuildingPermissionDialog(BuildingPermissionState state) {
        super(true);
        this.state = state;
    }

    @PostConstruct
    private void initializeDialog() {
        String letterDate = modelTranslations.toDisplayString(state.getDate());
        addDecoratedText("letter.location.date", "dateLocation", Pos.CENTER_RIGHT, state.getLocation(), letterDate);
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.title", "title", Pos.CENTER);
        addVerticalSpacer(20);
        IPlayer player = state.getPlayer();
        String careerLevel = modelTranslations.getLocalDisplayName(player.getCareerLevel());
        String rank = modelTranslations.getLocalDisplayName(player.getRank());
        addDecoratedText("letter.salutation.with.title", "salutation", careerLevel, rank, player.getName(), player.getLastName());
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.permission", "permission", state.getLocation());
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.greetings", "greetings");
        addVerticalSpacer(20);
        addDecoratedText("ch.sahits.game.openpatrician.display.dialog.event.BuildingPermissionDialog.signature", "signature", Pos.CENTER_RIGHT, state.getLocation());
    }
}
