package ch.sahits.game.openpatrician.display.dialog.sea;

import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.IDialogCentralButton;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.javafx.service.DecoratedTextFactory;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.ship.ConvoyList;
import ch.sahits.game.openpatrician.model.ship.IConvoy;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.VBox;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * Dialog handling the leaving of a ship from a convoy.
 * @author Andi Hotz, (c) Sahits GmbH, 2016
 *         Created on Feb 08, 2016
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class LeaveConvoyDialog extends CloseButtonDialog implements IDialogCentralButton{
    private final Logger logger = LogManager.getLogger(getClass());
    /** Reference to the city view model */
    private final ICityPlayerProxyJFX city;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private Locale locale;
    @Autowired
    private DecoratedTextFactory textFactory;
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private ConvoyList convoyList;


    private final IConvoy convoy;
    private final IShip ship;

    public LeaveConvoyDialog(ICityPlayerProxyJFX city, IConvoy convoy, IShip ship) {
        this.city = city;
        this.convoy = convoy;
        this.ship = ship;
    }

    @PostConstruct
    private void initializeDialog() {

        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.title", new Object[]{}, locale.getCurrentLocal()));
        String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.text", new Object[]{ship.getName(), convoy.getName()}, locale.getCurrentLocal());
        DecoratedText text = textFactory.createDecoratedText(template, new HashMap<>());
        VBox box = new VBox(text);
        box.setLayoutX(50);
        box.setLayoutY(CLOSE_BTN_Y_POS - 500);


        OpenPatricianLargeWaxButton acceptBtn = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.sea.LeaveConvoyDialog.leave", new Object[]{}, locale.getCurrentLocal()));
        acceptBtn.getStyleClass().add("actionButton");
        acceptBtn.setId("actionButton");
        acceptBtn.setLayoutX(BUTTON_X);
        acceptBtn.setOnAction(createAcceptHandler(ship));
        acceptBtn.setLayoutY(UPPER_BUTTON_Y);

        getContent().addAll(box, acceptBtn);

    }

    private EventHandler<MouseEvent> createAcceptHandler(IShip ship) {
        return event -> {
            try {
                convoy.removeShip(ship);
                ship.parentShipProperty().setValue(null);
                final ICityPlayerProxyJFX proxy = viewState.getCurrentCityProxy().get();
                proxy.arrive(ship);
                proxy.getPlayer().addSelectableVessel(ship);
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                logger.error("Failed to leave convoy", e);
            }
        };
    }
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_SHIP_SELECTION);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
}
