package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.IBuyer;
import ch.sahits.game.openpatrician.model.product.EWare;
import ch.sahits.game.openpatrician.model.service.ModelTranslations;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernBuyerDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private TimedUpdatableTaskList timedTaskList;
    @Autowired
    private ClientTaskFactory taskFactory;

    @Autowired
    private ModelTranslations translator;

    public TavernBuyerDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getBuyer());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernBuyerDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IBuyer buyer = (IBuyer) currentPerson.get();

        int p = buyer.getAmountablePrice().getAVGPrice()*buyer.getAmountablePrice().getAmount();
        Object[] args = new Object[]{buyer.getName(),
                buyer.getAmountablePrice().getAmount(),
                translator.getLocalDisplayName((EWare)buyer.getWare()), p};
        String key = "ch.sahits.game.openpatrician.display.dialog.TavernBuyerDialog.bale.dialog";
        if (buyer.getWare().isBarrelSizedWare()) {
            key = "ch.sahits.game.openpatrician.display.dialog.TavernBuyerDialog.barrel.dialog";
        }
        String loadedText = messageSource.getMessage(key, args, locale.getCurrentLocal());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, new HashMap<>());

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                final IBuyer buyer = (IBuyer) currentPerson.get();
                timedTaskList.add(taskFactory.getBuyWares(city, buyer));
                buyer.leave();
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                logger.error("Failed to accept buyers offer", e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            @Override
            protected boolean computeValue() {
                return false;
            }
        };
    }

}
