package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.clientserverinterface.service.ClientServerFactory;
import ch.sahits.game.openpatrician.clientserverinterface.service.DialogTemplateParameterSupplier;
import ch.sahits.game.openpatrician.clientserverinterface.service.EDialogTemplateType;
import ch.sahits.game.openpatrician.clientserverinterface.service.LinearDeadlinePremiumCalculator;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.people.IEscorte;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernEscortDialog extends TavernBaseSideRoomPersonDialog {
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientServerFactory clientServerFactory;

    public TavernEscortDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getEscorte());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.title", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IEscorte escort = (IEscorte) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.dialog", new Object[0], locale.getCurrentLocal());

        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("destination", escort.getDestination().getName());
        parameters.put("price", escort.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                if ((IShip) city.getActiveShip() != null) {
                    IEscorte escort = (IEscorte) currentPerson.get();
                    IShip ship = (IShip) city.getActiveShip();
                    ship.addPassenger(escort);
                    final LocalDateTime now = date.getCurrentDate();
                    final LocalDateTime deadline = now.plusWeeks(3);
                    LinearDeadlinePremiumCalculator premiumCalculator = clientServerFactory.premiumCalculator(now, deadline, escort.getPremium());
                    DialogTemplateParameterSupplier parameterSupplier = new DialogTemplateParameterSupplier(new Object[]{escort.getDestination().getName(), ship.getName(), clientServerFactory.dateSupplier(), premiumCalculator});
                    eventHandlerFactory.getPassengerLeavingOnShipArrivalHandler(ship, escort.getDestination(), city.getPlayer(), deadline, EDialogTemplateType.ESCORT_LEAVES_SHIP, parameterSupplier, premiumCalculator);
                    clientEventBus.post(new DisplayMessage("ch.sahits.game.openpatrician.display.dialog.TavernEscortDialog.acceptMessage", new Object[]{ship.getName()}));
                    escort.leave();
                    city.getPlayer().updateCrimialDrive(-1);
                    executeOnCloseButtonClicked();
                }
            } catch (RuntimeException e) {
                logger.error("Failed to accept escorts offer", e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                if (city.getActiveShip() instanceof IShip) {
                    ((IShip)city.getActiveShip()).passengerPresentProperty();
                }
            }
            @Override
            protected boolean computeValue() {
                return !(city.getActiveShip() instanceof IShip) || city.getPlayersShips().isEmpty() || ((IShip)city.getActiveShip()).passengerPresentProperty().get();
            }
        };
    }
}
