package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.display.event.data.PatrolInternalState;
import ch.sahits.game.openpatrician.display.event.handler.IAttackListener;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.people.IPatrol;
import ch.sahits.game.openpatrician.model.ship.IShip;
import javafx.beans.binding.BooleanBinding;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import org.springframework.beans.factory.annotation.Autowired;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Random;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 27, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPatrolDialog extends TavernBaseSideRoomPersonDialog {

    @Autowired
    private Random rnd;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private ClientTaskFactory taskFactory;


    public TavernPatrolDialog(ICityPlayerProxyJFX city) {
        super(city, city.getCity().getCityState().getTavernState().getPatrol());
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.model.people.impl.PatrolState.noticeboardTitle", new Object[]{}, locale.getCurrentLocal()));
        initializeButtons();
        IPatrol patrol = (IPatrol) currentPerson.get();

        String loadedText = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPatrolDialog.dialog", new Object[]{}, locale.getCurrentLocal());


        HashMap<String, Object> parameters = new HashMap<>();
        parameters.put("patrolName", patrol.getName());
        parameters.put("price", patrol.getPremium());
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().addAll(dt);
    }

    @Override
    protected EventHandler<MouseEvent> createAcceptHandler() {
        return mouseEvent -> {
            try {
                IPatrol patrol = (IPatrol) currentPerson.get();
                PatrolInternalState patrolState = new PatrolInternalState(patrol.getPremium(), patrol.getBonus(), patrol.getDestinations());
                IShip ship = null;
                if (city.getActiveShip() instanceof IShip) {
                    ship = (IShip) city.getActiveShip();
                }
                IPlayer player = city.getPlayer();
                IAttackListener attackListener = eventHandlerFactory.getAttackListener(ship, patrolState);
                int minutes = rnd.nextInt(600);
                LocalDateTime postMessage = date.getCurrentDate().plusMinutes(minutes);
                String cityName = patrolState.nextDestination().get().getName();
                taskFactory.getPostponedDisplayMessage(postMessage, "ch.sahits.game.openpatrician.display.dialog.TavernPatrolDialog.acceptMessage", new Object[]{ship.getName(), cityName});
                LocalDateTime firstDeadline = date.getCurrentDate().plusDays(6);
                eventHandlerFactory.getNextPatrolStateion(ship, patrolState.nextDestination().get(), patrolState, player, firstDeadline, attackListener);
                patrol.leave();
                executeOnCloseButtonClicked();
            } catch (RuntimeException e) {
                logger.error("Failed to accept patrol offer", e);
            }
        };
    }

    @Override
    protected BooleanBinding disableAcceptButton() {
        return new BooleanBinding() {
            {
                super.bind(city.getPlayersShips());
                // todo: andi 23/12/13: should not consider ships that are automated in some way (these are the ships which's capacity may change)
            }
            @Override
            protected boolean computeValue() {
                for (IShip ship : city.getPlayersShips()) {
                            if (ship.getCaptian() != null) {
                                // todo: andi 27/12/13: also check weapons and crew
                                return false;
                            }
                }
                return true;
            }
        };
    }
}
