package ch.sahits.game.openpatrician.display.dialog.tavern;

import ch.sahits.game.openpatrician.event.EViewChangeEvent;
import ch.sahits.game.openpatrician.event.NoticeBoardUpdate;
import ch.sahits.game.openpatrician.display.event.handler.impl.EventHandlerFactory;
import ch.sahits.game.openpatrician.display.ClientViewState;
import ch.sahits.game.openpatrician.display.dialog.ClosableDialog;
import ch.sahits.game.openpatrician.display.dialog.CloseButtonDialog;
import ch.sahits.game.openpatrician.display.dialog.service.DialogUtil;
import ch.sahits.game.openpatrician.display.dialog.service.TavernDialogUtil;
import ch.sahits.game.openpatrician.display.model.ViewChangeCityPlayerProxyJFX;
import ch.sahits.game.openpatrician.display.event.task.ClientTaskFactory;
import ch.sahits.game.openpatrician.javafx.control.DecoratedText;
import ch.sahits.game.openpatrician.javafx.control.OpenPatricianLargeWaxButton;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ObjectPropertyType;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.clientserverinterface.client.ICityPlayerProxyJFX;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.city.impl.TavernState;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.model.event.TimedUpdatableTaskList;
import ch.sahits.game.openpatrician.model.people.INonFreeSeaPirate;
import ch.sahits.game.openpatrician.model.people.IPirate;
import ch.sahits.game.openpatrician.clientserverinterface.model.factory.PeopleFactory;
import ch.sahits.game.openpatrician.model.people.impl.SeaPiratesState;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.event.EventHandler;
import javafx.event.WeakEventHandler;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Random;

/**
 * Dialog for offering a ship to a pirate.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 *         Created on Dec 22, 2013
 */
@Prototype
@ClassCategory({EClassCategory.DIALOG, EClassCategory.PROTOTYPE_BEAN, EClassCategory.UNRELEVANT_FOR_DESERIALISATION})
public class TavernPirateDialog extends CloseButtonDialog implements ClosableDialog {
    private final Logger logger = LogManager.getLogger(getClass());

    private final ICityPlayerProxyJFX city;
    @ObjectPropertyType(IShip.class)
    private final ObjectProperty<IShip> currentShip;
    @Autowired
    private DialogUtil dialogUtil;
    @Autowired
    private SeaPiratesState seaPiratesState;
    @Autowired
    private Random rnd;
    @Autowired
    private Date date;
    @Autowired
    private TimedUpdatableTaskList timedTaskListener;
    @Autowired
    private ClientViewState viewState;
    @Autowired
    private EventHandlerFactory eventHandlerFactory;
    @Autowired
    private Locale locale;
    @Autowired
    private TavernDialogUtil tavernDialogUtil;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private PeopleFactory peopleFactory;
    @Autowired
    private ClientTaskFactory taskFactory;

    private final IPirate pirate;
    private EventHandler<MouseEvent>  hirePirateEventHandler;
    private final TavernState tavernState;


    public TavernPirateDialog(ICityPlayerProxyJFX city) {
        super();
        this.city = city;
        this.currentShip = new SimpleObjectProperty<>(this, "currentShip", null);
        if (city.getActiveShip() instanceof IShip) {
            currentShip.setValue((IShip) city.getActiveShip());
        }
        tavernState = city.getCity().getCityState().getTavernState();
        pirate = city.getCity().getCityState().getTavernState().getPirate();
    }
    @PostConstruct
    private void initializeDialog() {
        setTitle(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPirateDialog.title", new Object[]{}, locale.getCurrentLocal()));

        int share = (int)Math.rint(pirate.getProfitShare()*100);
        String loadedText = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPirateDialog.dialog", new Object[]{pirate.getFollowers(), share}, locale.getCurrentLocal());


        HashMap<String, Object> parameters = new HashMap<>();
        DecoratedText dt = decoratedTextFactory.createDecoratedText(loadedText, parameters);

        getContent().add(dt);

        if (currentShip.get() == null) {
            String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernCaptainDialog.noShip", new Object[]{}, locale.getCurrentLocal());
            DecoratedText noShip = decoratedTextFactory.createDecoratedText(template, parameters);
            noShip.setLayoutX(2*FRAME_BORDER);
            noShip.setLayoutY(300);
            getContent().add(noShip);
        } else {
            String template = messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPirateDialog.shipSelection", new Object[]{}, locale.getCurrentLocal());
            DecoratedText selectedShip = decoratedTextFactory.createDecoratedText(template, parameters);
            selectedShip.setLayoutX(2*FRAME_BORDER);
            selectedShip.setLayoutY(300);
            getContent().add(selectedShip);
            GridPane shipSelectionPane = dialogUtil.createShipSelection3LinesForShips(city.getPlayersShips(), currentShip);
            shipSelectionPane.setLayoutX(2 * FRAME_BORDER);
            shipSelectionPane.setLayoutY(350);
            getContent().add(shipSelectionPane);
            int xFirstButton = (100);
            int xSecondButton = (WIDTH - 100 - 124);

            OpenPatricianLargeWaxButton wholeHanse = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPirateDialog.wholeHanse", new Object[]{}, locale.getCurrentLocal()));
            wholeHanse.getStyleClass().add("actionButton");
            wholeHanse.setLayoutX(xFirstButton);
            wholeHanse.setLayoutY(CLOSE_BTN_Y_POS - 24);
            hirePirateEventHandler =   event -> {
                try {
                    boolean wholeHanseFlag = ((Node) event.getSource()).getId().equals("wholeHanse");
                    final INonFreeSeaPirate seaPirate = peopleFactory.createNewPirate(pirate.getName(), currentShip.get(), city.getPlayer(), wholeHanseFlag ? null : city.getCity());
                    seaPiratesState.add(seaPirate);
                    int nbDays = rnd.nextInt(200) + 30;
                    LocalDateTime deadline = date.getCurrentDate().plusDays(nbDays);
                    TimedTask task = taskFactory.getFreePirateTask(seaPirate, deadline);
                    timedTaskListener.add(task);
                    city.getPlayer().removeShip(currentShip.get());
                    city.getPlayer().removeSelectableVessel(currentShip.get());
                    pirate.leave();

                    int caughtProb = rnd.nextInt(3);
                    if (caughtProb == 1) {
                        deadline = date.getCurrentDate().plusDays(5);
                        final int fine = (int) (Math.abs(city.getPlayer().getCompany().getCash() / 200 * rnd.nextDouble()));
                        task = taskFactory.getFinedTask(city.getPlayer(), fine, "ch.sahits.game.event.handler.impl.HirePirateEventHandler.fineMessage", deadline);
                        timedTaskListener.add(task);
                    }
                    city.getPlayer().updateCrimialDrive(1);

                    executeOnCloseButtonClicked();
                } catch (RuntimeException e) {
                    logger.error("Failed to accept pirates offer", e);
                }
            };
            wholeHanse.setOnAction(new WeakEventHandler<>(hirePirateEventHandler));
            wholeHanse.setId("wholeHanse");
            OpenPatricianLargeWaxButton local = new OpenPatricianLargeWaxButton(messageSource.getMessage("ch.sahits.game.openpatrician.display.dialog.TavernPirateDialog.local", new Object[]{city.getCity().getName()}, locale.getCurrentLocal()));
            local.getStyleClass().add("actionButton");
            local.setLayoutX(xSecondButton);
            local.setLayoutY(CLOSE_BTN_Y_POS - 24);
            local.setOnAction(new WeakEventHandler<>(hirePirateEventHandler));
            local.setId("local");


            getContent().addAll(wholeHanse, local) ;

        }
    }

    /**
     * Update the notice board and close the dialog.
     */
    @Override
    public void executeOnCloseButtonClicked() {
        ViewChangeCityPlayerProxyJFX proxy = new ViewChangeCityPlayerProxyJFX(viewState.getCurrentCityProxy().get(), EViewChangeEvent.NOTICE_TAVERN);
        clientEventBus.post(new NoticeBoardUpdate(proxy));
        super.executeOnCloseButtonClicked();
    }
    @Override
    public void close() {
        super.close();
        tavernDialogUtil.stopTalkingToPerson(tavernState, city.getPlayer());
    }

}
