package ch.sahits.game.openpatrician.display.event.data;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import ch.sahits.game.openpatrician.model.city.ICity;
import java.util.Optional;
import com.google.common.collect.Lists;

import java.util.List;

import static java.util.Arrays.asList;

/**
* @author Andi Hotz, (c) Sahits GmbH, 2014
*         Created on Feb 16, 2014
*/
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class CourierPatrolStateInternal {
    private final int premium;
    @ListType(ICity.class)
    private List<ICity> cities = Lists.newArrayList();
    public CourierPatrolStateInternal(int premium, ICity[] destinations) {
        super();
        this.premium = premium;
        cities.addAll(asList(destinations));
    }
    public int getPremium() {
        return premium;
    }
    public void removeFirstCity() {
        cities.remove(0);
    }
    public Optional<ICity> nextDestination() {
        if (cities.isEmpty()) {
            return Optional.empty();
        } else {
            return Optional.of(cities.get(0));
        }
    }
}
