package ch.sahits.game.openpatrician.display.event.data;

import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.ListType;
import com.google.common.collect.Lists;

import java.util.List;
import java.util.Optional;

/**
 * Patrol state.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Feb 21, 2014
 */
@ClassCategory(EClassCategory.DEPENDS_ON_SERIALIZED_BEAN)
public class PatrolInternalState {
    private final int premium;
    private final int bonusPerAttack;
    private int numberOfAttacks = 0;
    @ListType(ICity.class)
    private List<ICity> cities = Lists.newArrayList();
    public PatrolInternalState(int premium, int bonusPerAttack, ICity[] destinations) {
        super();
        this.premium = premium;
        cities = Lists.newArrayList(destinations);
        this.bonusPerAttack = bonusPerAttack;
    }
    public int getPremium() {
        return premium;
    }
    public int getBonusPerAttack() {
        return bonusPerAttack;
    }
    public int getNumberOfAttacks() {
        return numberOfAttacks;
    }
    public void incAttackCounter() {
        numberOfAttacks++;
    }
    public void removeFirstCity() {
        cities.remove(0);
    }
    public Optional<ICity> nextDestination() {
        if (cities.isEmpty()) {
            return Optional.empty();
        } else {
            return Optional.of(cities.get(0));
        }
    }}
