package ch.sahits.game.openpatrician.display.event.handler;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;

import java.time.LocalDateTime;

/**
 * This timed task serves as notice, in the case that the player does not
 * pay his debt before the deadline. In that case something will be impounded.
 * @author Andi Hotz, (c) Sahits GmbH, 2013
 * Created on Feb 23, 2013
 *
 */
@ClassCategory({EClassCategory.PROTOTYPE_BEAN, EClassCategory.SERIALIZABLE_BEAN})
@Prototype
public class LoanerRepayDeptByPlayer extends TimedTask {
	private final IPlayer player;
	// Need additional information city or loaner object

	public LoanerRepayDeptByPlayer(LocalDateTime executionTime, IPlayer debitor) {
		super();
        setExecutionTime(executionTime);
		player = debitor;
	}

	@Override
	public void run() {

	}

}
