package ch.sahits.game.openpatrician.display.event.handler;

import ch.sahits.game.openpatrician.event.data.NewGameClient;
import ch.sahits.game.openpatrician.display.javafx.control.GameStatus;
import ch.sahits.game.openpatrician.display.javafx.control.ViewStatus;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.LazySingleton;
import com.google.common.eventbus.AsyncEventBus;
import com.google.common.eventbus.Subscribe;
import javafx.application.Platform;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import javax.annotation.PostConstruct;

/**
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Jan 18, 2014
 */
@LazySingleton
@ClassCategory(EClassCategory.SINGLETON_BEAN)
public class StartNewGameHandler {
    @Autowired
    @Qualifier("serverClientEventBus")
    private AsyncEventBus clientServerEventBus;
    @Autowired
    private GameStatus gameStatus;
    @Autowired
    private ViewStatus viewStatus;

    @PostConstruct
    private void initializeEventSystem() {
        clientServerEventBus.register(this);
    }
    @Subscribe
    public void handleNewGameStart(NewGameClient newGameDTO) {
        Platform.runLater(() -> {
            gameStatus.bindToPlayer(newGameDTO.getPlayer());
            viewStatus.setCity(newGameDTO.getPlayer().getHometown().getName());
            clientServerEventBus.unregister(this);
        });

    }

}
