package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import java.time.LocalDateTime;
import java.util.Random;

/**
 * Event handler for delivering packages
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class DeliverPackages extends WaitTimeForShipArrivalInCity {
    private final int amount;
    private final int premium;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    private MessageSource messageSource;

    public DeliverPackages(ICity city, IShip ship, LocalDateTime deadline, int premium, int amount) {
        super(city, ship, deadline);
        this.premium = premium;
        this.amount = amount;
    }

    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void unregisterEventBus() { clientServerEventBus.unregister(this);}
    @Override
    public boolean execute(ICity city) {
        ((IShip)getShip()).setOccupiedSpace(((IShip)getShip()).getOccupiedSpace() - amount);
        IPlayer owner = (IPlayer) getShip().getOwner();
        if (rnd.nextBoolean()) {
            int penalty = (int)(Math.abs(owner.getCompany().getCash()/200*rnd.nextDouble()));
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageCaught", new Object[]{penalty});
            clientEventBus.post(msg);
            if (owner instanceof IHumanPlayer) {
                owner.getCompany().updateCash(-penalty);
            } else {
                owner.getCompany().updateCashDirectly(-penalty);
            }
        } else {
            if (owner instanceof IHumanPlayer) {
                owner.getCompany().updateCash(premium);
            } else {
                owner.getCompany().updateCashDirectly(premium);
            }
            DisplayMessage msg = new DisplayMessage("ch.sahits.game.event.handler.impl.DeliverPackages.messageSuccess");
            clientEventBus.post(msg);
        }
        unregisterEventBus();
        return false;
    }
    @Override
    public void destroy() {
        ((IShip)getShip()).setOccupiedSpace(((IShip)getShip()).getOccupiedSpace() - amount);
        super.destroy();
    }

}
