package ch.sahits.game.openpatrician.display.event.handler.impl;

import ch.sahits.game.openpatrician.event.handler.ShipEntersPortEventListener;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.city.ICity;
import ch.sahits.game.openpatrician.model.ship.IShip;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;

/**
 * Unload the anonymous ware upon arrival in the city.
 * @author Andi Hotz, (c) Sahits GmbH, 2014
 *         Created on Dec 20, 2014
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class UnloadOnArival extends ShipEntersPortEventListener {
    private final int amountLoaded;
    public UnloadOnArival(IShip ship, ICity city, int loaded) {
        super(ship, city);
        this.amountLoaded = loaded;
    }
    @PostConstruct
    private void initializeEventBus() {
        clientServerEventBus.register(this);
    }
    @PreDestroy
    private void unregisterEventBus() { clientServerEventBus.unregister(this);}
    @Override
    public boolean execute(ICity city) {
        ((IShip)getShip()).setOccupiedSpace(((IShip)getShip()).getOccupiedSpace() - amountLoaded);
        unregisterEventBus();
        return true;
    }
}
