package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.Date;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import ch.sahits.game.openpatrician.utilities.l10n.Locale;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;

import javax.annotation.PostConstruct;
import java.util.Random;

/**
* @author Andi Hotz, (c) Sahits GmbH, 2014
*         Created on Feb 23, 2014
*/
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
class BreakInAction extends TimedTask implements IBreakInAction {
    @Autowired
    private Date date;
    @Autowired
    @XStreamOmitField
    private Random rnd;
    @Autowired
    @XStreamOmitField
    private Locale locale;
    @Autowired
    @XStreamOmitField
    @Qualifier("messageSource")
    private MessageSource messageSource;
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;

    private final IPlayer opponent;
    public BreakInAction(IPlayer opponent) {
        super();
        this.opponent = opponent;
    }
    @PostConstruct
    private void initializ() {
        setExecutionTime(date.getCurrentDate().plusDays(5));
    }
    @Override
    public void run() {
        int bounty = (int)(Math.abs(opponent.getCompany().getCash()/2000*rnd.nextDouble()));
        if (opponent instanceof IHumanPlayer) {
            opponent.getCompany().updateCash(-bounty);
        } else {
            opponent.getCompany().updateCashDirectly(-bounty);
        }
        DisplayMessage msg = new DisplayMessage("ch.sahits.game.graphic.event.task.BreakInAction.message", new Object[]{bounty, opponent.getLastName()});
        clientEventBus.post(msg);
    }

}
