package ch.sahits.game.openpatrician.display.event.task;

import ch.sahits.game.openpatrician.utilities.annotation.ClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.EClassCategory;
import ch.sahits.game.openpatrician.utilities.annotation.Prototype;
import ch.sahits.game.openpatrician.model.DisplayMessage;
import ch.sahits.game.openpatrician.model.IHumanPlayer;
import ch.sahits.game.openpatrician.model.event.TimedTask;
import com.google.common.eventbus.AsyncEventBus;
import com.thoughtworks.xstream.annotations.XStreamOmitField;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

import java.time.LocalDateTime;

/**
 * Timed task for getting fined.
 * Created by andi on 25.03.17.
 */
@Prototype
@ClassCategory({EClassCategory.SERIALIZABLE_BEAN, EClassCategory.PROTOTYPE_BEAN})
public class FinedTimedTask extends TimedTask {
    @Autowired
    @Qualifier("clientEventBus")
    @XStreamOmitField
    private AsyncEventBus clientEventBus;

    private final IHumanPlayer player;
    private final int fine;
    private final String messageKey;

    public FinedTimedTask(IHumanPlayer player, int fine, String messageKey, LocalDateTime deadline) {
        this.player = player;
        this.fine = fine;
        this.messageKey = messageKey;
        setExecutionTime(deadline);
    }

    @Override
    public void run() {
        DisplayMessage msg = new DisplayMessage(messageKey, new Object[]{fine});
        clientEventBus.post(msg);
        if (player instanceof IHumanPlayer) {
            player.getCompany().updateCash(-fine);
        } else {
            player.getCompany().updateCashDirectly(-fine);
        }
    }
}
